/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.notification.ClusterNodeNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.core.internal.connector.SchedulerController;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.module.extension.internal.runtime.source.AbstractExtensionMessageSourceTestCase;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapter;

public class ClusterExtensionMessageSourceTestCase
extends AbstractExtensionMessageSourceTestCase {
    public ClusterExtensionMessageSourceTestCase() {
        this.primaryNodeOnly = true;
    }

    @Override
    public void before() throws Exception {
        super.before();
        SchedulerController schedulerController = (SchedulerController)Mockito.mock(SchedulerController.class);
        Mockito.when((Object)schedulerController.isPrimarySchedulingInstance()).thenReturn((Object)false);
        ((DefaultMuleContext)muleContext).setSchedulerController(schedulerController);
    }

    @Override
    protected SourceAdapter createSourceAdapter() {
        return (SourceAdapter)Mockito.spy((Object)super.createSourceAdapter());
    }

    @Test
    public void dontStartIfNotPrimaryNode() throws Exception {
        this.messageSource.initialise();
        this.messageSource.start();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.never())).initialise();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void startWhenPrimaryNode() throws Exception {
        this.dontStartIfNotPrimaryNode();
        muleContext.getNotificationManager().fireNotification((Notification)new ClusterNodeNotification((Object)"you're up", 1701));
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.atLeastOnce())).initialise();
        ((SourceAdapter)Mockito.verify((Object)this.sourceAdapter, (VerificationMode)Mockito.times((int)1))).start();
    }
}

