/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.UpdatingAuthorizationCodeState;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.builder.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class UpdatingAuthorizationCodeStateTestCase
extends AbstractMuleTestCase {
    private static final String ACCESS_TOKEN = "myToken";
    private static final String REFRESH_TOKEN = "myRefreshToken";
    private static final String NEW_TOKEN = "newToken";
    private static final String NEW_REFRESH_TOKEN = "newRefresh";
    private AuthorizationCodeConfig oAuthConfig;
    @Mock
    private AuthorizationCodeOAuthDancer dancer;
    @Mock
    private ResourceOwnerOAuthContext initialContext;
    @Mock
    private ResourceOwnerOAuthContext refreshedContext;

    @Before
    public void before() {
        this.oAuthConfig = new AuthorizationCodeConfig("configName", Optional.empty(), MultiMap.emptyMultiMap(), MultiMap.emptyMultiMap(), Collections.emptyMap(), new AuthorizationCodeGrantType("url", "url", "#[s]", "reg", "#[x]", "sd"), (OAuthCallbackConfig)Mockito.mock(OAuthCallbackConfig.class), "key", "secret", "url", "url", "scope", "id", null, null);
        Mockito.when((Object)this.initialContext.getAccessToken()).thenReturn((Object)ACCESS_TOKEN);
        Mockito.when((Object)this.initialContext.getRefreshToken()).thenReturn((Object)REFRESH_TOKEN);
        Mockito.when((Object)this.refreshedContext.getAccessToken()).thenReturn((Object)NEW_TOKEN);
        Mockito.when((Object)this.refreshedContext.getRefreshToken()).thenReturn((Object)NEW_REFRESH_TOKEN);
    }

    @Test
    public void onRefreshToken() throws Exception {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0));
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener((AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        listener.onTokenRefreshed(this.refreshedContext);
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)NEW_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)NEW_REFRESH_TOKEN));
        Assert.assertThat((Object)newContext.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.refreshedContext)));
    }

    @Test
    public void onReAuthorization() throws Exception {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0));
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener((AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        listener.onAuthorizationCompleted(this.refreshedContext);
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)NEW_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)NEW_REFRESH_TOKEN));
        Assert.assertThat((Object)newContext.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.refreshedContext)));
    }
}

