/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.internal.loader.AbstractInterceptable;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractInterceptableContractTestCase<T extends AbstractInterceptable>
extends AbstractMuleContextTestCase {
    @Mock(extraInterfaces={Lifecycle.class})
    protected Interceptor interceptor1;
    @Mock(extraInterfaces={Lifecycle.class})
    protected Interceptor interceptor2;
    protected Injector injector;
    protected T interceptable;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.interceptable = this.createInterceptable();
        muleContext.getInjector().inject(this.interceptable);
        this.injector = MuleTestUtils.spyInjector((MuleContext)muleContext);
    }

    protected abstract T createInterceptable();

    @Test
    public void interceptorsInjected() throws Exception {
        this.interceptable.initialise();
        ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.interceptor1);
        ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.interceptor2);
    }

    @Test
    public void interceptorsInitialised() throws Exception {
        this.interceptable.initialise();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.interceptor1))).initialise();
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.interceptor2))).initialise();
    }

    @Test
    public void interceptorsStarted() throws Exception {
        this.interceptable.start();
        ((Startable)Mockito.verify((Object)((Startable)this.interceptor1))).start();
        ((Startable)Mockito.verify((Object)((Startable)this.interceptor2))).start();
    }

    @Test
    public void interceptorsStopped() throws Exception {
        this.interceptable.initialise();
        this.interceptable.start();
        this.interceptable.stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.interceptor1))).stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.interceptor2))).stop();
    }

    @Test
    public void interceptorsDisposed() throws Exception {
        this.interceptable.initialise();
        this.interceptable.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.interceptor1))).dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.interceptor2))).dispose();
    }

    protected List<Interceptor> getInterceptors() {
        return ImmutableList.of((Object)this.interceptor1, (Object)this.interceptor2);
    }
}

