/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import reactor.core.publisher.Mono;

public class OAuthOperationMessageProcessor
extends OperationMessageProcessor {
    public OAuthOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache, DefaultExecutionMediator.ValueTransformer valueTransformer) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache, valueTransformer);
    }

    @Override
    protected Mono<CoreEvent> doProcess(CoreEvent event, ExecutionContextAdapter<OperationModel> operationContext) {
        return super.doProcess(event, operationContext).onErrorResume(Exception.class, e -> {
            boolean tokenRefreshed;
            try {
                tokenRefreshed = ExtensionsOAuthUtils.refreshTokenIfNecessary(operationContext, e);
            }
            catch (Exception refreshException) {
                return Mono.error((Throwable)refreshException);
            }
            if (tokenRefreshed) {
                return super.doProcess(event, operationContext);
            }
            return Mono.error((Throwable)e);
        });
    }
}

