/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.notification.NotificationEmitter;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.process.RouterCompletionCallback;
import org.mule.runtime.extension.api.runtime.process.VoidCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceResult;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategyFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationTransactionalActionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.BackPressureContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ComponentLocationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CorrelationInfoArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.DefaultEncodingArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ErrorArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExtensionsClientArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.FlowListenerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.LiteralArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MediaTypeArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NotificationHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.RetryPolicyTemplateArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.RouterCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SecurityContextHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCallbackContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceResultArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StreamingHelperArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.VoidCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.streaming.UnclosableCursorStream;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class MethodArgumentResolverDelegate
implements ArgumentResolverDelegate,
Initialisable {
    private static final ArgumentResolver<Object> CONFIGURATION_ARGUMENT_RESOLVER = new ConfigurationArgumentResolver();
    private static final ArgumentResolver<Object> CONNECTOR_ARGUMENT_RESOLVER = new ConnectionArgumentResolver();
    private static final ArgumentResolver<MediaType> MEDIA_TYPE_ARGUMENT_RESOLVER = new MediaTypeArgumentResolver();
    private static final ArgumentResolver<String> DEFAULT_ENCODING_ARGUMENT_RESOLVER = new DefaultEncodingArgumentResolver();
    private static final ArgumentResolver<SourceCallbackContext> SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER = new SourceCallbackContextArgumentResolver();
    private static final ArgumentResolver<Error> ERROR_ARGUMENT_RESOLVER = new ErrorArgumentResolver();
    private static final ArgumentResolver<CompletionCallback> NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER = new CompletionCallbackArgumentResolver();
    private static final ArgumentResolver<RouterCompletionCallback> ROUTER_CALLBACK_ARGUMENT_RESOLVER = new RouterCallbackArgumentResolver();
    private static final ArgumentResolver<VoidCompletionCallback> VOID_CALLBACK_ARGUMENT_RESOLVER = new VoidCallbackArgumentResolver();
    private static final ArgumentResolver<SourceCompletionCallback> ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER = new SourceCompletionCallbackArgumentResolver();
    private static final ArgumentResolver<AuthenticationHandler> SECURITY_CONTEXT_HANDLER = new SecurityContextHandlerArgumentResolver();
    private static final ArgumentResolver<FlowListener> FLOW_LISTENER_ARGUMENT_RESOLVER = new FlowListenerArgumentResolver();
    private static final ArgumentResolver<StreamingHelper> STREAMING_HELPER_ARGUMENT_RESOLVER = new StreamingHelperArgumentResolver();
    private static final ArgumentResolver<SourceResult> SOURCE_RESULT_ARGUMENT_RESOLVER = new SourceResultArgumentResolver(ERROR_ARGUMENT_RESOLVER, SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER);
    private static final ArgumentResolver<BackPressureContext> BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER = new BackPressureContextArgumentResolver();
    private static final ArgumentResolver<ComponentLocation> COMPONENT_LOCATION_ARGUMENT_RESOLVER = new ComponentLocationArgumentResolver();
    private static final ArgumentResolver<OperationTransactionalAction> OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER = new OperationTransactionalActionArgumentResolver();
    private static final ArgumentResolver<CorrelationInfo> CORRELATION_INFO_ARGUMENT_RESOLVER = new CorrelationInfoArgumentResolver();
    private static final ArgumentResolver<NotificationEmitter> NOTIFICATION_HANDLER_ARGUMENT_RESOLVER = new NotificationHandlerArgumentResolver();
    private static final ArgumentResolver<RetryPolicyTemplate> RETRY_POLICY_TEMPLATE_ARGUMENT_RESOLVER = new RetryPolicyTemplateArgumentResolver();
    @Inject
    private ReflectionCache reflectionCache;
    @Inject
    private ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory;
    @Inject
    private ExpressionManager expressionManager;
    private final List<ParameterGroupModel> parameterGroupModels;
    private final Method method;
    private final JavaTypeLoader typeLoader = new JavaTypeLoader(this.getClass().getClassLoader());
    private ArgumentResolver<?>[] argumentResolvers;
    private Map<Parameter, ParameterGroupArgumentResolver<?>> parameterGroupResolvers;

    public MethodArgumentResolverDelegate(List<ParameterGroupModel> parameterGroupModels, Method method) {
        this.parameterGroupModels = parameterGroupModels;
        this.method = method;
    }

    private void initArgumentResolvers() {
        Object[] parameterTypes = this.method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            this.argumentResolvers = new ArgumentResolver[0];
            return;
        }
        this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        Parameter[] parameters = this.method.getParameters();
        this.parameterGroupResolvers = this.getParameterGroupResolvers(this.parameterGroupModels);
        List<String> paramNames = MuleExtensionAnnotationParser.getParamNames(this.method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
            ArgumentResolver argumentResolver = annotations.containsKey(Config.class) ? CONFIGURATION_ARGUMENT_RESOLVER : (annotations.containsKey(Connection.class) ? CONNECTOR_ARGUMENT_RESOLVER : (annotations.containsKey(DefaultEncoding.class) ? DEFAULT_ENCODING_ARGUMENT_RESOLVER : (Error.class.isAssignableFrom((Class<?>)parameterType) ? ERROR_ARGUMENT_RESOLVER : (SourceCallbackContext.class.equals(parameterType) ? SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER : (IntrospectionUtils.isParameterContainer(annotations.keySet(), this.typeLoader.load((Type)parameterType)) && !((ParameterGroup)annotations.get(ParameterGroup.class)).showInDsl() ? (TypedValueArgumentResolver)((Object)this.parameterGroupResolvers.get(parameters[i])) : (ParameterResolver.class.equals(parameterType) ? new ParameterResolverArgumentResolver(paramNames.get(i)) : (TypedValue.class.equals(parameterType) ? new TypedValueArgumentResolver(paramNames.get(i)) : (Literal.class.equals(parameterType) ? new LiteralArgumentResolver(paramNames.get(i), parameterType) : (CompletionCallback.class.equals(parameterType) ? NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER : (ExtensionsClient.class.equals(parameterType) ? new ExtensionsClientArgumentResolver(this.extensionsClientProcessorsStrategyFactory) : (RouterCompletionCallback.class.equals(parameterType) ? ROUTER_CALLBACK_ARGUMENT_RESOLVER : (VoidCompletionCallback.class.equals(parameterType) ? VOID_CALLBACK_ARGUMENT_RESOLVER : (MediaType.class.equals(parameterType) ? MEDIA_TYPE_ARGUMENT_RESOLVER : (AuthenticationHandler.class.equals(parameterType) ? SECURITY_CONTEXT_HANDLER : (FlowListener.class.equals(parameterType) ? FLOW_LISTENER_ARGUMENT_RESOLVER : (StreamingHelper.class.equals(parameterType) ? STREAMING_HELPER_ARGUMENT_RESOLVER : (SourceResult.class.equals(parameterType) ? SOURCE_RESULT_ARGUMENT_RESOLVER : (BackPressureContext.class.equals(parameterType) ? BACK_PRESSURE_CONTEXT_ARGUMENT_RESOLVER : (SourceCompletionCallback.class.equals(parameterType) ? ASYNC_SOURCE_COMPLETION_CALLBACK_ARGUMENT_RESOLVER : (ComponentLocation.class.equals(parameterType) ? COMPONENT_LOCATION_ARGUMENT_RESOLVER : (OperationTransactionalAction.class.equals(parameterType) ? OPERATION_TRANSACTIONAL_ACTION_ARGUMENT_RESOLVER : (CorrelationInfo.class.equals(parameterType) ? CORRELATION_INFO_ARGUMENT_RESOLVER : (NotificationEmitter.class.equals(parameterType) ? NOTIFICATION_HANDLER_ARGUMENT_RESOLVER : (RetryPolicyTemplate.class.equals(parameterType) ? RETRY_POLICY_TEMPLATE_ARGUMENT_RESOLVER : new ByParameterNameArgumentResolver(paramNames.get(i))))))))))))))))))))))))));
            this.argumentResolvers[i] = argumentResolver;
        }
    }

    @Override
    public Supplier<Object>[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
        Supplier[] parameterValues = new Supplier[this.argumentResolvers.length];
        int i = 0;
        for (ArgumentResolver<?> argumentResolver : this.argumentResolvers) {
            parameterValues[i] = this.wrapParameterResolution(parameterTypes[i], argumentResolver.resolve(executionContext));
            ++i;
        }
        return parameterValues;
    }

    private Supplier<Object> wrapParameterResolution(Class<?> parameterType, Supplier<?> valueSupplier) {
        return () -> {
            Object parameterValue = valueSupplier.get();
            if (parameterValue == null) {
                return this.resolvePrimitiveTypeDefaultValue(parameterType);
            }
            if (parameterValue instanceof CursorStream) {
                return new UnclosableCursorStream((CursorStream)parameterValue);
            }
            return ResolverUtils.resolveCursor(parameterValue);
        };
    }

    private Object resolvePrimitiveTypeDefaultValue(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private Map<Parameter, ParameterGroupArgumentResolver<? extends Object>> getParameterGroupResolvers(List<ParameterGroupModel> parameterGroupModels) {
        return (Map)parameterGroupModels.stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null)).filter(group -> group != null && group.getContainer() instanceof Parameter).collect(Collectors.toImmutableMap(group -> (Parameter)group.getContainer(), group -> new ParameterGroupArgumentResolver((ParameterGroupDescriptor)group, this.reflectionCache, this.expressionManager)));
    }

    public void initialise() throws InitialisationException {
        this.initArgumentResolvers();
    }
}

