/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.security.CredentialsPlacement;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.ImmutableAuthorizationCodeState;
import org.mule.runtime.oauth.api.builder.ClientCredentialsLocation;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionsOAuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsOAuthUtils.class);

    public static AuthorizationCodeState toAuthorizationCodeState(AuthorizationCodeConfig config, ResourceOwnerOAuthContext context) {
        return new ImmutableAuthorizationCodeState(context.getAccessToken(), context.getRefreshToken(), context.getResourceOwnerId(), context.getExpiresIn(), context.getState(), config.getAuthorizationUrl(), config.getAccessTokenUrl(), config.getCallbackConfig().getExternalCallbackUrl(), config.getConsumerKey(), config.getConsumerSecret());
    }

    public static ClientCredentialsLocation toCredentialsLocation(CredentialsPlacement placement) {
        if (placement == CredentialsPlacement.BASIC_AUTH_HEADER) {
            return ClientCredentialsLocation.BASIC_AUTH_HEADER;
        }
        if (placement == CredentialsPlacement.QUERY_PARAMS) {
            return ClientCredentialsLocation.QUERY_PARAMS;
        }
        if (placement == CredentialsPlacement.BODY) {
            return ClientCredentialsLocation.BODY;
        }
        throw new IllegalArgumentException("Unsupported CredentialsPlacement type " + placement.name());
    }

    public static OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = (ConfigurationInstance)operationContext.getConfiguration().get();
        ConnectionProvider provider = ConnectionProviderUtils.unwrapProviderWrapper((ConnectionProvider)((ConnectionProvider)config.getConnectionProvider().get()), OAuthConnectionProviderWrapper.class);
        return provider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)provider : null;
    }

    public static boolean refreshTokenIfNecessary(final ExecutionContextAdapter<OperationModel> operationContext, Exception e) {
        final OAuthConnectionProviderWrapper connectionProvider = ExtensionsOAuthUtils.getOAuthConnectionProvider(operationContext);
        if (connectionProvider == null) {
            return false;
        }
        AccessTokenExpiredException expiredException = ExtensionsOAuthUtils.getTokenExpirationException(e);
        if (expiredException == null) {
            return false;
        }
        final Reference resourceOwnerIdReference = new Reference(Optional.empty());
        connectionProvider.getGrantType().accept(new OAuthGrantTypeVisitor(){

            public void visit(AuthorizationCodeGrantType grantType) {
                AuthorizationCodeConnectionProviderWrapper cp = (AuthorizationCodeConnectionProviderWrapper)connectionProvider;
                String rsId = cp.getResourceOwnerId();
                resourceOwnerIdReference.set(Optional.of(rsId));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AccessToken for resourceOwner '{}' expired at operation '{}:{}' using config '{}'. Will attempt to refresh token and retry operation", new Object[]{rsId, operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()});
                }
            }

            public void visit(ClientCredentialsGrantType grantType) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AccessToken expired at operation '{}:{}' using config '{}'. Will attempt to refresh token and retry operation", new Object[]{operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()});
                }
            }
        });
        Optional resourceOwnerId = (Optional)resourceOwnerIdReference.get();
        try {
            connectionProvider.refreshToken(resourceOwnerId.orElse(""));
        }
        catch (Exception refreshException) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("AccessToken %s expired at operation '%s:%s' using config '%s'. Refresh token workflow was attempted but failed with the following exception", ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), operationContext.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName())), (Throwable)refreshException);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access Token successfully refreshed {} on config '{}'", (Object)ExtensionsOAuthUtils.forResourceOwner(resourceOwnerId), (Object)((ConfigurationInstance)operationContext.getConfiguration().get()).getName());
        }
        return true;
    }

    private static AccessTokenExpiredException getTokenExpirationException(Exception e) {
        return ExceptionUtils.extractOfType((Throwable)e, AccessTokenExpiredException.class).orElse(null);
    }

    private static String forResourceOwner(Optional<String> resourceOwnerId) {
        return resourceOwnerId.map(id -> "for resource owner '" + id + "'").orElse("");
    }

    private ExtensionsOAuthUtils() {
    }
}

