/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.transaction.TransactionManager;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.util.mediatype.PayloadMediaTypeResolver;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.MessageProcessTemplate;
import org.mule.runtime.core.privileged.execution.MessageProcessingManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceCallbackContext;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionNotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.ModuleFlowExtensionsProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandlerFactory;
import org.mule.runtime.module.extension.internal.runtime.source.SourceConnectionManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.TransactionSourceBinder;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

class DefaultSourceCallback<T, A>
implements SourceCallbackAdapter<T, A> {
    private SourceModel sourceModel;
    private Set<String> notificationModelNames;
    private ConfigurationInstance configurationInstance;
    private Processor listener;
    private MuleContext muleContext;
    private String applicationName;
    private NotificationDispatcher notificationDispatcher;
    private SingleResourceTransactionFactoryManager transactionFactoryManager;
    private ExtensionMessageSource messageSource;
    private ExceptionCallback<ConnectionException> exceptionCallback;
    private MessageProcessingManager messageProcessingManager;
    private Supplier<MessageProcessContext> processContextSupplier;
    private SourceCompletionHandlerFactory completionHandlerFactory;
    private CursorProviderFactory cursorProviderFactory;
    private TransactionConfig transactionConfig;
    private boolean returnsListOfMessages = false;
    private MediaType defaultMediaType;
    private TransactionSourceBinder transactionSourceBinder;
    private Charset defaultEncoding;
    private Optional<MediaType> mimeTypeInitParam;
    private Optional<Charset> encodingParam;
    private final Once.RunOnce resolveInitializationParams = Once.of(() -> {
        this.defaultEncoding = SystemUtils.getDefaultEncoding((MuleContext)this.muleContext);
        Map<String, Object> initialisationParameters = this.messageSource.getInitialisationParameters();
        this.encodingParam = Optional.ofNullable((String)initialisationParameters.get("outputEncoding")).map(MediaTypeUtils::parseCharset);
        this.mimeTypeInitParam = Optional.ofNullable((String)initialisationParameters.get("outputMimeType")).map(MediaType::parseDefinedInApp);
    });

    static Builder builder() {
        return new Builder();
    }

    private DefaultSourceCallback() {
    }

    public void handle(Result<T, A> result) {
        this.handle(result, this.createContext());
    }

    public void handle(Result<T, A> result, SourceCallbackContext context) {
        this.resolveInitializationParams.runOnce();
        Preconditions.checkArgument((boolean)(context instanceof SourceCallbackContextAdapter), (String)"The supplied context was not created through this callback, you naughty developer");
        SourceCallbackContextAdapter contextAdapter = (SourceCallbackContextAdapter)context;
        this.validateNotifications(contextAdapter);
        MessageProcessContext messageProcessContext = this.processContextSupplier.get();
        MediaType mediaType = this.resolveMediaType(result);
        PayloadMediaTypeResolver payloadMediaTypeResolver = new PayloadMediaTypeResolver(SystemUtils.getDefaultEncoding((MuleContext)this.muleContext), this.defaultMediaType, this.encodingParam, this.mimeTypeInitParam);
        SourceResultAdapter resultAdapter = new SourceResultAdapter(result, this.cursorProviderFactory, mediaType, this.returnsListOfMessages, context.getCorrelationId(), payloadMediaTypeResolver);
        this.executeFlow(context, messageProcessContext, resultAdapter);
        contextAdapter.dispatched();
    }

    private void validateNotifications(SourceCallbackContextAdapter contextAdapter) {
        contextAdapter.getNotificationsFunctions().forEach(sourceNotification -> {
            String notificationName = ((ExtensionNotificationFunction)sourceNotification).getActionName();
            Preconditions.checkArgument((boolean)this.notificationModelNames.contains(notificationName), () -> String.format("Cannot fire notification '%s' since it's not declared by the component.", notificationName));
        });
    }

    private void executeFlow(SourceCallbackContext context, MessageProcessContext messageProcessContext, SourceResultAdapter resultAdapter) {
        SourceCallbackContextAdapter contextAdapter = (SourceCallbackContextAdapter)context;
        this.messageProcessingManager.processMessage((MessageProcessTemplate)new ModuleFlowExtensionsProcessingTemplate(resultAdapter, this.listener, contextAdapter.getNotificationsFunctions(), this.completionHandlerFactory.createCompletionHandler(contextAdapter)), messageProcessContext);
    }

    protected MediaType resolveMediaType(Object value) {
        Optional optionalMediaType;
        Charset existingEncoding = this.defaultEncoding;
        MediaType mediaType = this.defaultMediaType;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent()) {
            mediaType = (MediaType)optionalMediaType.get();
            existingEncoding = mediaType.getCharset().orElse(existingEncoding);
        }
        return this.mimeTypeInitParam.orElse(mediaType).withCharset(this.encodingParam.orElse(existingEncoding));
    }

    public void onConnectionException(ConnectionException e) {
        this.exceptionCallback.onException((Throwable)e);
    }

    public SourceCallbackContext createContext() {
        return new DefaultSourceCallbackContext(this);
    }

    @Override
    public TransactionSourceBinder getTransactionSourceBinder() {
        return this.transactionSourceBinder;
    }

    @Override
    public ConfigurationInstance getConfigurationInstance() {
        return this.configurationInstance;
    }

    @Override
    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public SourceConnectionManager getSourceConnectionManager() {
        return this.messageSource.getSourceConnectionManager();
    }

    @Override
    public String getOwningSourceName() {
        return this.sourceModel.getName();
    }

    @Override
    public String getOwningExtensionName() {
        return this.messageSource.getExtensionModel().getName();
    }

    @Override
    public ComponentLocation getSourceLocation() {
        return this.messageSource.getLocation();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.muleContext.getTransactionManager();
    }

    @Override
    public int getTimeout() {
        return this.getTransactionConfig().getTimeout();
    }

    static class Builder<T, A> {
        private final DefaultSourceCallback<T, A> product = new DefaultSourceCallback();

        private Builder() {
        }

        public Builder<T, A> setSourceModel(SourceModel sourceModel) {
            ((DefaultSourceCallback)this.product).sourceModel = sourceModel;
            ((DefaultSourceCallback)this.product).returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages((HasOutputModel)sourceModel);
            ((DefaultSourceCallback)this.product).defaultMediaType = org.mule.runtime.module.extension.internal.util.MediaTypeUtils.getDefaultMediaType((ComponentModel)sourceModel);
            ((DefaultSourceCallback)this.product).notificationModelNames = sourceModel.getNotificationModels().stream().map(NotificationModel::getIdentifier).collect(Collectors.toSet());
            return this;
        }

        public Builder<T, A> setConfigurationInstance(ConfigurationInstance configurationInstance) {
            ((DefaultSourceCallback)this.product).configurationInstance = configurationInstance;
            return this;
        }

        public Builder<T, A> setTransactionConfig(TransactionConfig transactionConfig) {
            ((DefaultSourceCallback)this.product).transactionConfig = transactionConfig;
            return this;
        }

        public Builder<T, A> setListener(Processor listener) {
            ((DefaultSourceCallback)this.product).listener = listener;
            return this;
        }

        public Builder<T, A> setMuleContext(MuleContext muleContext) {
            ((DefaultSourceCallback)this.product).muleContext = muleContext;
            return this;
        }

        public Builder<T, A> setApplicationName(String applicationName) {
            ((DefaultSourceCallback)this.product).applicationName = applicationName;
            return this;
        }

        public Builder<T, A> setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
            ((DefaultSourceCallback)this.product).notificationDispatcher = notificationDispatcher;
            return this;
        }

        public Builder<T, A> setTransactionFactoryManager(SingleResourceTransactionFactoryManager transactionFactoryManager) {
            ((DefaultSourceCallback)this.product).transactionFactoryManager = transactionFactoryManager;
            return this;
        }

        public Builder<T, A> setSource(ExtensionMessageSource messageSource) {
            ((DefaultSourceCallback)this.product).messageSource = messageSource;
            return this;
        }

        public Builder<T, A> setExceptionCallback(ExceptionCallback<ConnectionException> exceptionCallback) {
            ((DefaultSourceCallback)this.product).exceptionCallback = exceptionCallback;
            return this;
        }

        public Builder<T, A> setProcessingManager(MessageProcessingManager processingManager) {
            ((DefaultSourceCallback)this.product).messageProcessingManager = processingManager;
            return this;
        }

        public Builder<T, A> setProcessContextSupplier(Supplier<MessageProcessContext> processContextSupplier) {
            ((DefaultSourceCallback)this.product).processContextSupplier = processContextSupplier;
            return this;
        }

        public Builder<T, A> setCompletionHandlerFactory(SourceCompletionHandlerFactory completionHandlerFactory) {
            ((DefaultSourceCallback)this.product).completionHandlerFactory = completionHandlerFactory;
            return this;
        }

        public Builder<T, A> setCursorStreamProviderFactory(CursorProviderFactory cursorProviderFactory) {
            ((DefaultSourceCallback)this.product).cursorProviderFactory = cursorProviderFactory;
            return this;
        }

        public SourceCallback<T, A> build() {
            this.checkArgument(((DefaultSourceCallback)this.product).listener, "listener");
            this.checkArgument(((DefaultSourceCallback)this.product).exceptionCallback, "exceptionCallback");
            this.checkArgument(((DefaultSourceCallback)this.product).messageProcessingManager, "messageProcessingManager");
            this.checkArgument(((DefaultSourceCallback)this.product).processContextSupplier, "processContextSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).completionHandlerFactory, "completionHandlerSupplier");
            this.checkArgument(((DefaultSourceCallback)this.product).sourceModel, "source");
            this.checkArgument(((DefaultSourceCallback)this.product).cursorProviderFactory, "cursorStreamProviderFactory");
            this.checkArgument((Object)((DefaultSourceCallback)this.product).messageSource, "messageSource");
            this.checkArgument(((DefaultSourceCallback)this.product).applicationName, "applicationName");
            this.checkArgument(((DefaultSourceCallback)this.product).notificationDispatcher, "notificationDispatcher");
            this.checkArgument(((DefaultSourceCallback)this.product).transactionFactoryManager, "transactionFactoryManager");
            ((DefaultSourceCallback)this.product).transactionSourceBinder = new TransactionSourceBinder(((DefaultSourceCallback)this.product).messageSource.getExtensionModel(), (ComponentModel)((DefaultSourceCallback)this.product).sourceModel, ((DefaultSourceCallback)this.product).applicationName, ((DefaultSourceCallback)this.product).notificationDispatcher, ((DefaultSourceCallback)this.product).transactionFactoryManager);
            return this.product;
        }

        private void checkArgument(Object value, String name) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)(name + " was not set"));
        }
    }
}

