/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.util.EventUtils;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;

public class DefaultStreamingHelper
implements StreamingHelper {
    private final CursorStreamProviderFactory cursorStreamProviderFactory;
    private final CursorIteratorProviderFactory cursorIteratorProviderFactory;
    private final CursorComponentDecoratorFactory componentDecoratorFactory;
    private final CoreEvent event;
    private final ComponentLocation originatingLocation;

    public DefaultStreamingHelper(CursorStreamProviderFactory cursorStreamProviderFactory, CursorIteratorProviderFactory cursorIteratorProviderFactory, CursorComponentDecoratorFactory componentDecoratorFactory, CoreEvent event, ComponentLocation originatingLocation) {
        this.cursorStreamProviderFactory = cursorStreamProviderFactory;
        this.cursorIteratorProviderFactory = cursorIteratorProviderFactory;
        this.componentDecoratorFactory = componentDecoratorFactory;
        this.event = event;
        this.originatingLocation = originatingLocation;
    }

    public <K> Map<K, Object> resolveCursors(Map<K, Object> map, boolean recursive) {
        return this.resolveMap(map, recursive, ResolverUtils::resolveCursor);
    }

    public <K> Map<K, Object> resolveCursorProviders(Map<K, Object> map, boolean recursive) {
        return this.resolveMap(map, recursive, this::resolveCursorProvider);
    }

    public Object resolveCursor(Object value) {
        return ResolverUtils.resolveCursor(value);
    }

    public Object resolveCursorProvider(Object value) {
        if (value instanceof Cursor) {
            return ((Cursor)value).getProvider();
        }
        if (value instanceof InputStream) {
            value = this.resolveCursorStreamProvider(this.componentDecoratorFactory.decorateOutput((InputStream)value, this.event.getCorrelationId()));
        } else if (value instanceof Iterator) {
            value = this.resolveCursorIteratorProvider(this.componentDecoratorFactory.decorateOutput((Iterator)value, this.event.getCorrelationId()));
        } else if (value instanceof TypedValue) {
            value = this.resolveCursorTypedValueProvider((TypedValue)value);
        }
        return value;
    }

    private Object resolveCursorStreamProvider(InputStream value) {
        return this.cursorStreamProviderFactory.of(EventUtils.getRoot((EventContext)this.event.getContext()), (Object)value, this.originatingLocation);
    }

    private Object resolveCursorIteratorProvider(Iterator value) {
        return this.cursorIteratorProviderFactory.of(EventUtils.getRoot((EventContext)this.event.getContext()), (Object)value, this.originatingLocation);
    }

    private TypedValue resolveCursorTypedValueProvider(TypedValue value) {
        Object resolvedValue = this.resolveCursorProvider(value.getValue());
        if (resolvedValue != value.getValue()) {
            return new TypedValue(resolvedValue, value.getDataType());
        }
        return value;
    }

    private <K> Map<K, Object> resolveMap(Map<K, Object> map, boolean recursive, Function<Object, Object> valueMapper) {
        Map<K, Map<K, Object>> resolved;
        Preconditions.checkArgument((map != null ? 1 : 0) != 0, (String)"Map cannot be null");
        try {
            resolved = (Map)ClassUtils.instantiateClass(map.getClass(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            resolved = new LinkedHashMap();
        }
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            Map<K, Object> value = valueMapper.apply(entry.getValue());
            if (recursive && value instanceof Map) {
                value = this.resolveCursors(value, recursive);
            }
            resolved.put(entry.getKey(), value);
        }
        return resolved;
    }
}

