/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.FeatureFlaggingService;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalSourceModelDefinitionException;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.source.BackPressureAction;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.SourceFactory;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.property.ComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.execution.deprecated.ComponentExecutorCompletableAdapterFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.deprecated.ReactiveOperationExecutorFactoryWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class MuleExtensionUtils {
    private static final String IMPLICIT_CONFIGURATION_SUFFIX = "-implicit";

    public static boolean returnsListOfMessages(HasOutputModel componentModel) {
        MetadataType outputType = componentModel.getOutput().getType();
        return outputType instanceof ArrayType && Message.class.getName().equals(ExtensionMetadataTypeUtils.getId((MetadataType)((ArrayType)outputType).getType()).orElse(null));
    }

    public static <T> boolean hasAnyDynamic(Iterable<ValueResolver<T>> resolvers) {
        for (ValueResolver<T> resolver : resolvers) {
            if (!resolver.isDynamic()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> toMap(ResolverSet resolverSet, ValueResolvingContext ctx) throws MuleException {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, ValueResolver<?>> entry : resolverSet.getResolvers().entrySet()) {
            Object value = entry.getValue().resolve(ctx);
            if (value == null) continue;
            map.put((Object)entry.getKey(), value);
        }
        return map.build();
    }

    public static boolean isNullSafe(ParameterModel parameterModel) {
        return parameterModel.getModelProperty(NullSafeModelProperty.class).isPresent();
    }

    public static List<ConnectionProviderModel> getAllConnectionProviders(ExtensionModel extensionModel, ConfigurationModel configurationModel) {
        return ImmutableList.builder().addAll((Iterable)configurationModel.getConnectionProviders()).addAll((Iterable)extensionModel.getConnectionProviders()).build();
    }

    public static boolean supportsOAuth(ExtensionModel extensionModel) {
        final Reference connectionProvider = new Reference();
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (model.getModelProperty(OAuthModelProperty.class).isPresent()) {
                    connectionProvider.set((Object)model);
                    this.stop();
                }
            }
        }.walk(extensionModel);
        return connectionProvider.get() != null;
    }

    public static ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader).orElse(Thread.currentThread().getContextClassLoader());
    }

    public static <T> T withExtensionClassLoader(ExtensionModel extensionModel, Callable<T> callable) throws Exception {
        return (T)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), callable);
    }

    public static byte toActionCode(OperationTransactionalAction action) {
        switch (action) {
            case ALWAYS_JOIN: {
                return 3;
            }
            case JOIN_IF_POSSIBLE: {
                return 4;
            }
            case NOT_SUPPORTED: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + action.name());
    }

    public static byte toActionCode(SourceTransactionalAction action) {
        switch (action) {
            case ALWAYS_BEGIN: {
                return 1;
            }
            case NONE: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + action.name());
    }

    public static MessageSource.BackPressureStrategy toBackPressureStrategy(BackPressureMode mode) {
        switch (mode) {
            case WAIT: {
                return MessageSource.BackPressureStrategy.WAIT;
            }
            case FAIL: {
                return MessageSource.BackPressureStrategy.FAIL;
            }
            case DROP: {
                return MessageSource.BackPressureStrategy.DROP;
            }
        }
        throw new IllegalArgumentException("Unmapped mode " + mode.name());
    }

    public static MessageSource.BackPressureStrategy toBackPressureStrategy(String backPressureModeName) {
        return MuleExtensionUtils.toBackPressureStrategy(BackPressureMode.valueOf((String)backPressureModeName));
    }

    public static Optional<BackPressureAction> toBackPressureAction(MessageSource.BackPressureStrategy backPressureStrategy) {
        if (backPressureStrategy == MessageSource.BackPressureStrategy.FAIL) {
            return Optional.of(BackPressureAction.FAIL);
        }
        if (backPressureStrategy == MessageSource.BackPressureStrategy.DROP) {
            return Optional.of(BackPressureAction.DROP);
        }
        if (backPressureStrategy == MessageSource.BackPressureStrategy.WAIT) {
            return Optional.empty();
        }
        throw new IllegalArgumentException("Unsupported BackPressureStrategy " + backPressureStrategy);
    }

    public static ConfigurationFactory getConfigurationFactory(ConfigurationModel configurationModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)configurationModel, ConfigurationFactoryModelProperty.class, ConfigurationFactoryModelProperty::getConfigurationFactory, () -> new IllegalConfigurationModelDefinitionException(String.format("Configuration '%s' does not provide a %s", configurationModel.getName(), ConfigurationFactory.class.getName())));
    }

    @Deprecated
    public static <T extends ComponentModel> ComponentExecutorFactory<T> getLegacyOperationExecutorFactory(T operationModel) {
        ComponentExecutorFactory executorFactory = MuleExtensionUtils.fromModelProperty(operationModel, ComponentExecutorModelProperty.class, ComponentExecutorModelProperty::getExecutorFactory, () -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not provide a %s", operationModel.getName(), ComponentExecutorFactory.class.getSimpleName())));
        return new ReactiveOperationExecutorFactoryWrapper(executorFactory);
    }

    public static <T extends ComponentModel> CompletableComponentExecutorFactory<T> getOperationExecutorFactory(T operationModel) {
        if (operationModel.getModelProperty(ComponentExecutorModelProperty.class).isPresent()) {
            return new ComponentExecutorCompletableAdapterFactory<T>(MuleExtensionUtils.getLegacyOperationExecutorFactory(operationModel));
        }
        return MuleExtensionUtils.fromModelProperty(operationModel, CompletableComponentExecutorModelProperty.class, CompletableComponentExecutorModelProperty::getExecutorFactory, () -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not provide a %s", operationModel.getName(), CompletableComponentExecutorModelProperty.class.getSimpleName())));
    }

    public static boolean isNonBlocking(ComponentModel model) {
        if (model instanceof OperationModel) {
            return !((OperationModel)model).isBlocking();
        }
        return model instanceof ConstructModel;
    }

    public static MetadataResolverFactory getMetadataResolverFactory(EnrichableModel model) {
        return model.getModelProperty(MetadataResolverFactoryModelProperty.class).map(MetadataResolverFactoryModelProperty::getMetadataResolverFactory).orElse((MetadataResolverFactory)new NullMetadataResolverFactory());
    }

    public static SourceFactory getSourceFactory(SourceModel sourceModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)sourceModel, SourceFactoryModelProperty.class, SourceFactoryModelProperty::getSourceFactory, () -> new IllegalSourceModelDefinitionException(String.format("Source '%s' does not provide a %s", sourceModel.getName(), SourceFactory.class.getSimpleName())));
    }

    public static ConnectionProviderFactory getConnectionProviderFactory(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)connectionProviderModel, ConnectionProviderFactoryModelProperty.class, ConnectionProviderFactoryModelProperty::getConnectionProviderFactory, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not provide a %s", connectionProviderModel.getName(), ConnectionProviderFactory.class.getSimpleName())));
    }

    public static Type getConnectionType(ConnectionProviderModel connectionProviderModel) {
        return MuleExtensionUtils.fromModelProperty((EnrichableModel)connectionProviderModel, ConnectionTypeModelProperty.class, ConnectionTypeModelProperty::getConnectionTypeElement, () -> new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider '%s' does not specify a connection type", connectionProviderModel.getName())));
    }

    private static <T, P extends ModelProperty> T fromModelProperty(EnrichableModel model, Class<P> modelPropertyType, Function<P, T> map, Supplier<? extends RuntimeException> exceptionSupplier) {
        return model.getModelProperty(modelPropertyType).map(map).orElseThrow(exceptionSupplier);
    }

    public static String getExtensionsNamespace(ExtensionModel extensionModel) {
        return MuleExtensionUtils.getExtensionsNamespace(extensionModel.getXmlDslModel());
    }

    public static String getExtensionsNamespace(ExtensionDeclaration extensionDeclaration) {
        return MuleExtensionUtils.getExtensionsNamespace(extensionDeclaration.getXmlDslModel());
    }

    private static String getExtensionsNamespace(XmlDslModel dslModel) {
        return dslModel.getPrefix().toUpperCase();
    }

    public static ExtensionModel loadExtension(Class<?> clazz) {
        return MuleExtensionUtils.loadExtension(clazz, (Map<String, Object>)new SmallMap());
    }

    public static ExtensionModel loadExtension(Class<?> clazz, Map<String, Object> params) {
        params.put("type", clazz.getName());
        params.put("version", "4.0.0-SNAPSHOT");
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.singleton(MuleExtensionModelProvider.getExtensionModel()));
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(clazz.getClassLoader(), dslResolvingContext, params);
    }

    public static String getImplicitConfigurationProviderName(ExtensionModel extensionModel, ConfigurationModel configurationModel, ArtifactType extendedArtifactType, String extendedArtifactId, FeatureFlaggingService extendedArtifactFeatureFlaggingService) {
        if (extendedArtifactType.equals((Object)ArtifactType.POLICY)) {
            return MuleExtensionUtils.getFeatureFlaggedPolicyExtensionsImplicitConfigurationProviderName(extensionModel, configurationModel, extendedArtifactId, extendedArtifactFeatureFlaggingService);
        }
        return MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, configurationModel);
    }

    private static String getFeatureFlaggedPolicyExtensionsImplicitConfigurationProviderName(ExtensionModel extensionModel, ConfigurationModel configurationModel, String extendedArtifactId, FeatureFlaggingService featureFlaggingService) {
        if (featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, configurationModel, extendedArtifactId);
        }
        return MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, configurationModel);
    }

    private static String getImplicitConfigurationProviderName(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel, String extendedArtifactId) {
        return extensionModel.getName() + "-" + implicitConfigurationModel.getName() + "-" + extendedArtifactId + IMPLICIT_CONFIGURATION_SUFFIX;
    }

    private static String getImplicitConfigurationProviderName(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel) {
        return extensionModel.getName() + "-" + implicitConfigurationModel.getName() + IMPLICIT_CONFIGURATION_SUFFIX;
    }

    public static boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            return trim.startsWith("#[") && trim.endsWith("]");
        }
        return false;
    }

    public static boolean isCompileTime(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(CompileTimeModelProperty.class).isPresent();
    }

    public static boolean isSynthetic(EnrichableModel enrichableModel) {
        return enrichableModel.getModelProperty(SyntheticModelModelProperty.class).isPresent();
    }

    public static Optional<Class> getImplementingType(EnrichableModel enrichableModel) {
        return enrichableModel.getModelProperty(ImplementingTypeModelProperty.class).map(mp -> mp.getType());
    }

    public static MutableConfigurationStats getMutableConfigurationStats(ExecutionContext<?> context) {
        if (context.getConfiguration().isPresent()) {
            return (MutableConfigurationStats)((ConfigurationInstance)context.getConfiguration().get()).getStatistics();
        }
        return null;
    }

    public static boolean isConnectedStreamingOperation(ComponentModel componentModel) {
        if (componentModel instanceof ConnectableComponentModel) {
            ConnectableComponentModel connectableComponentModel = (ConnectableComponentModel)componentModel;
            return connectableComponentModel.requiresConnection() && (connectableComponentModel.supportsStreaming() || connectableComponentModel.getModelProperty(PagedOperationModelProperty.class).isPresent());
        }
        return false;
    }

    public static void checkParameterGroupExclusiveness(Optional<ParameterizedModel> model, List<ParameterGroupModel> groups, Map<String, ?> parameters, Map<String, String> aliasedParameterNames) throws ConfigurationException {
        for (ParameterGroupModel group : groups) {
            for (ExclusiveParametersModel exclusiveModel : group.getExclusiveParametersModels()) {
                Set<String> parameterNames = MuleExtensionUtils.resolveParameterNames(group, parameters, aliasedParameterNames);
                Collection definedExclusiveParameters = CollectionUtils.intersection((Collection)exclusiveModel.getExclusiveParameterNames(), parameterNames);
                if (definedExclusiveParameters.isEmpty() && exclusiveModel.isOneRequired()) {
                    throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Parameter group '%s' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [%s]", group.getName(), Joiner.on((String)", ").join((Iterable)exclusiveModel.getExclusiveParameterNames()))));
                }
                if (definedExclusiveParameters.size() <= 1) continue;
                if (model.isPresent()) {
                    throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("In %s '%s', the following parameters cannot be set at the same time: [%s]", NameUtils.getComponentModelTypeName((ParameterizedModel)model.get()), NameUtils.getModelName((Object)model.get()), Joiner.on((String)", ").join((Iterable)definedExclusiveParameters))));
                }
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("The following parameters cannot be set at the same time: [%s]", Joiner.on((String)", ").join((Iterable)definedExclusiveParameters))));
            }
        }
    }

    private static Set<String> resolveParameterNames(ParameterGroupModel group, Map<String, ?> parameters, Map<String, String> aliasedParameterNames) throws ConfigurationException {
        if (group.isShowInDsl()) {
            ExtensionParameterDescriptorModelProperty property = (ExtensionParameterDescriptorModelProperty)group.getModelProperty(ExtensionParameterDescriptorModelProperty.class).orElseThrow(() -> new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Could not find ExtensionParameterDescriptorModelProperty for the parameter group %s", (Object[])new Object[]{group.getName()})));
            String containerName = property.getExtensionParameter().getName();
            try {
                Object parameter = parameters.get(containerName);
                if (parameter == null) {
                    throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Was expecting a parameter with name [%s] among the resolved parameters", (Object[])new Object[]{containerName}));
                }
                if (parameter instanceof ParameterValueResolver) {
                    return ((ParameterValueResolver)parameter).getParameters().keySet().stream().map(name -> aliasedParameterNames.getOrDefault(name, (String)name)).collect(Collectors.toSet());
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Was expecting parameter with name [%s] to be of class ParameterValueResolver but was of class %s", (Object[])new Object[]{containerName, parameters.get(containerName).getClass()}));
            }
            catch (ValueResolvingException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed to resolve the parameters for [%s]", (Object[])new Object[]{containerName}), (Throwable)e);
            }
        }
        HashSet<String> topLevelParameterNames = new HashSet<String>();
        parameters.forEach((key, value) -> {
            aliasedParameterNames.getOrDefault(key, (String)key);
            topLevelParameterNames.add((String)key);
        });
        return topLevelParameterNames;
    }
}

