/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.client.OperationParameters;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategyFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import reactor.core.publisher.Mono;

public final class DefaultExtensionsClient
implements ExtensionsClient,
Initialisable {
    @Inject
    private ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory;
    private final CoreEvent event;
    private ExtensionsClientProcessorsStrategy extensionsClientProcessorsStrategy;

    public DefaultExtensionsClient(CoreEvent event, ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory) {
        this.event = event;
        this.extensionsClientProcessorsStrategyFactory = extensionsClientProcessorsStrategyFactory;
    }

    public DefaultExtensionsClient() {
        this.event = null;
    }

    public <T, A> CompletableFuture<Result<T, A>> executeAsync(String extension, String operation, OperationParameters parameters) {
        OperationMessageProcessor processor = this.extensionsClientProcessorsStrategy.getOperationMessageProcessor(extension, operation, parameters);
        CoreEvent eventFromParams = this.extensionsClientProcessorsStrategy.getEvent(parameters);
        return Mono.just((Object)eventFromParams).transform((Function)((Object)processor)).map(event -> Result.builder((Message)event.getMessage()).build()).onErrorMap(t -> {
            Throwable unwrapped = Exceptions.unwrap((Throwable)t);
            if (unwrapped instanceof MessagingException) {
                return unwrapped;
            }
            return new MessagingException(eventFromParams, unwrapped, (Component)processor);
        }).doAfterTerminate(() -> this.extensionsClientProcessorsStrategy.disposeProcessor(processor)).toFuture();
    }

    public <T, A> Result<T, A> execute(String extension, String operation, OperationParameters params) throws MuleException {
        OperationMessageProcessor processor = this.extensionsClientProcessorsStrategy.getOperationMessageProcessor(extension, operation, params);
        CoreEvent eventFromParams = this.extensionsClientProcessorsStrategy.getEvent(params);
        try {
            CoreEvent process = processor.process(eventFromParams);
            Result result = Result.builder((Message)process.getMessage()).build();
            return result;
        }
        catch (Exception e) {
            Throwable unwrapped = Exceptions.unwrap((Throwable)e);
            if (unwrapped instanceof MessagingException) {
                throw (MessagingException)unwrapped;
            }
            throw new MessagingException(eventFromParams, unwrapped, (Component)processor);
        }
        finally {
            this.extensionsClientProcessorsStrategy.disposeProcessor(processor);
        }
    }

    public void initialise() throws InitialisationException {
        this.extensionsClientProcessorsStrategy = this.extensionsClientProcessorsStrategyFactory.create(this.event);
    }
}

