/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.strategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.ForwardingExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.CachedExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.NonCachedExtensionsClientProcessorsStrategy;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.OperationMessageProcessorUtils;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ExtensionsClientProcessorsStrategyFactory
implements Initialisable,
Disposable {
    private static int MAX_CACHE_SIZE = 100;
    private static int CACHE_ENTRY_EXPIRE_AFTER_ACCESS_IN_MINUTES = 10;
    private boolean usesCachedStrategy;
    private Cache<String, OperationMessageProcessor> operationMessageProcessorCache;
    private final ShutdownExecutor cacheShutdownExecutor = new ShutdownExecutor();
    @Inject
    private ExtensionManager extensionManager;
    @Inject
    private Registry registry;
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyManager policyManager;
    @Inject
    private ReflectionCache reflectionCache;

    public ExtensionsClientProcessorsStrategy create(CoreEvent event) {
        return this.usesCachedStrategy ? new CachedExtensionsClientProcessorsStrategy(this.extensionManager, this.registry, this.muleContext, this.policyManager, this.reflectionCache, event, this.operationMessageProcessorCache) : new NonCachedExtensionsClientProcessorsStrategy(this.extensionManager, this.registry, this.muleContext, this.policyManager, this.reflectionCache, event);
    }

    public void initialise() throws InitialisationException {
        boolean bl = this.usesCachedStrategy = !Boolean.parseBoolean(System.getProperty("mule.extensionsClient.disableCache"));
        if (this.usesCachedStrategy) {
            this.operationMessageProcessorCache = this.createCache();
        }
    }

    private Cache<String, OperationMessageProcessor> createCache() {
        return Caffeine.newBuilder().maximumSize((long)MAX_CACHE_SIZE).executor((Executor)((Object)this.cacheShutdownExecutor)).expireAfterAccess((long)CACHE_ENTRY_EXPIRE_AFTER_ACCESS_IN_MINUTES, TimeUnit.MINUTES).removalListener((key, operationMessageProcessor, removalCause) -> OperationMessageProcessorUtils.disposeProcessor(operationMessageProcessor)).build();
    }

    public void dispose() {
        if (this.operationMessageProcessorCache != null) {
            this.operationMessageProcessorCache.invalidateAll();
        }
        this.cacheShutdownExecutor.shutdown();
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)((Object)this.cacheShutdownExecutor), (long)5L, (TimeUnit)TimeUnit.SECONDS);
    }

    private static final class ShutdownExecutor
    extends ForwardingExecutorService {
        private final AtomicInteger tasks = new AtomicInteger();
        private final Semaphore semaphore = new Semaphore(0);
        private volatile boolean shutdown;

        private ShutdownExecutor() {
        }

        public void execute(Runnable task) {
            if (this.shutdown) {
                throw new RejectedExecutionException("Shutdown");
            }
            this.tasks.incrementAndGet();
            this.delegate().execute(() -> {
                try {
                    task.run();
                }
                finally {
                    this.semaphore.release();
                }
            });
        }

        public void shutdown() {
            this.shutdown = true;
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            int permits = this.tasks.get();
            boolean terminated = this.semaphore.tryAcquire(permits, timeout, unit);
            if (terminated) {
                this.semaphore.release(permits);
            }
            return terminated && this.shutdown;
        }

        public boolean isTerminated() {
            try {
                return this.awaitTermination(0L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        protected ExecutorService delegate() {
            return ForkJoinPool.commonPool();
        }
    }
}

