/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ValueProviderUtils {
    private ValueProviderUtils() {
    }

    static ValueBuilder cloneAndEnrichValue(Value value, Map<Integer, String> partOrderMapping) {
        return ValueProviderUtils.cloneAndEnrichValue(value, partOrderMapping, 1);
    }

    static ValueBuilder cloneAndEnrichValue(Value value, List<ParameterModel> parameters) {
        return ValueProviderUtils.cloneAndEnrichValue(value, ValueProviderUtils.orderParts(parameters), 1);
    }

    static ValueBuilder cloneAndEnrichValue(Value value, Map<Integer, String> partOrderMapping, int level) {
        ValueBuilder keyBuilder = ValueBuilder.newValue((String)value.getId(), (String)partOrderMapping.get(level)).withDisplayName(value.getDisplayName());
        value.getChilds().forEach(childKey -> keyBuilder.withChild(ValueProviderUtils.cloneAndEnrichValue(childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }

    private static Map<Integer, String> orderParts(List<ParameterModel> parameters) {
        return parameters.stream().collect(Collectors.toMap(param -> ((ValueProviderModel)param.getValueProviderModel().get()).getPartOrder(), NamedObject::getName));
    }

    public static List<ValueProviderModel> getValueProviderModels(List<ParameterModel> parameterModels) {
        return parameterModels.stream().map(parameterModel -> parameterModel.getValueProviderModel().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Set<Value> valuesWithClassLoader(Callable<Set<Value>> valueResolver, ExtensionModel extensionModel) throws ValueResolvingException {
        Reference exceptionReference = new Reference();
        Set values = (Set)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), valueResolver, ValueResolvingException.class, e -> {
            exceptionReference.set((Object)((ValueResolvingException)e));
            return null;
        });
        if (exceptionReference.get() != null) {
            throw (ValueResolvingException)exceptionReference.get();
        }
        return values;
    }
}

