/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.InputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;
import org.mule.runtime.module.extension.internal.metadata.MetadataResolverUtils;

class MetadataInputDelegate
extends BaseMetadataDelegate {
    MetadataInputDelegate(EnrichableModel model) {
        super(model);
    }

    MetadataResult<InputMetadataDescriptor> getInputMetadataDescriptors(MetadataContext context, Object key) {
        InputMetadataDescriptor.InputMetadataDescriptorBuilder input = InputMetadataDescriptor.builder();
        LinkedList<MetadataResult<ParameterMetadataDescriptor>> results = new LinkedList<MetadataResult<ParameterMetadataDescriptor>>();
        if (!(this.model instanceof ParameterizedModel)) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage("The given component has not parameter definitions to be described").onComponent()});
        }
        for (ParameterModel parameter : ((ParameterizedModel)this.model).getParameterGroupModels().stream().flatMap(parameterGroupModel -> parameterGroupModel.getParameterModels().stream()).collect(Collectors.toList())) {
            MetadataResult<ParameterMetadataDescriptor> result = this.getParameterMetadataDescriptor(parameter, context, key);
            input.withParameter(parameter.getName(), (ParameterMetadataDescriptor)result.get());
            results.add(result);
        }
        List failures = results.stream().flatMap(e -> e.getFailures().stream()).collect(Collectors.toList());
        return failures.isEmpty() ? MetadataResult.success((Object)input.build()) : MetadataResult.failure((Object)input.build(), failures);
    }

    NamedTypeResolver getParameterResolver(String parameterName) {
        return this.resolverFactory.getInputResolver(parameterName);
    }

    private MetadataResult<ParameterMetadataDescriptor> getParameterMetadataDescriptor(ParameterModel parameter, MetadataContext context, Object key) {
        ParameterMetadataDescriptor.ParameterMetadataDescriptorBuilder descriptorBuilder = ParameterMetadataDescriptor.builder((String)parameter.getName());
        if (!parameter.hasDynamicType()) {
            return MetadataResult.success((Object)descriptorBuilder.withType(parameter.getType()).build());
        }
        descriptorBuilder.dynamic(true);
        MetadataResult<MetadataType> inputMetadataResult = this.getParameterMetadata(parameter, context, key);
        MetadataType type = inputMetadataResult.get() == null ? parameter.getType() : (MetadataType)inputMetadataResult.get();
        ParameterMetadataDescriptor descriptor = descriptorBuilder.withType(type).build();
        return inputMetadataResult.isSuccess() ? MetadataResult.success((Object)descriptor) : MetadataResult.failure((Object)descriptor, (List)inputMetadataResult.getFailures());
    }

    private MetadataResult<MetadataType> getParameterMetadata(ParameterModel parameter, MetadataContext context, Object key) {
        try {
            boolean allowsNullType = !parameter.isRequired() && parameter.getDefaultValue() == null;
            MetadataType metadata = (MetadataType)MetadataResolverUtils.resolveWithOAuthRefresh(context, () -> this.resolverFactory.getInputResolver(parameter.getName()).getInputMetadata(context, key));
            if (this.isMetadataResolvedCorrectly(metadata, allowsNullType)) {
                return MetadataResult.success((Object)this.adaptToListIfNecessary(metadata, parameter, context));
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage(String.format("Error resolving metadata for the [%s] input parameter", parameter.getName())).withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onParameter(parameter.getName());
            return MetadataResult.failure((Object)parameter.getType(), (MetadataFailure[])new MetadataFailure[]{failure});
        }
        catch (Exception e) {
            return MetadataResult.failure((Object)parameter.getType(), (MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onParameter(parameter.getName())});
        }
    }

    private MetadataType adaptToListIfNecessary(MetadataType resolvedType, ParameterModel parameter, MetadataContext metadataContext) throws MetadataResolvingException {
        MetadataType inputType = parameter.getType();
        if (!MetadataTypeUtils.isCollection((MetadataType)inputType) || MetadataTypeUtils.isNullType((MetadataType)resolvedType)) {
            return resolvedType;
        }
        return metadataContext.getTypeBuilder().arrayType().with((TypeAnnotation)new ClassInformationAnnotation(JavaTypeUtils.getType((MetadataType)inputType))).of(resolvedType).build();
    }
}

