/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectBasedParameterValueResolver
implements ParameterValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectBasedParameterValueResolver.class);
    private final Object object;
    private final ParameterizedModel parameterizedModel;
    private final ReflectionCache reflectionCache;

    public ObjectBasedParameterValueResolver(Object object, ParameterizedModel parameterizedModel, ReflectionCache reflectionCache) {
        this.object = object;
        this.parameterizedModel = parameterizedModel;
        this.reflectionCache = reflectionCache;
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        try {
            Optional<Field> field = IntrospectionUtils.getField(this.object.getClass(), parameterName, this.reflectionCache);
            if (field.isPresent()) {
                return IntrospectionUtils.getFieldValue(this.object, parameterName, this.reflectionCache);
            }
            Object returnValue = null;
            for (ParameterGroupModel parameterGroupModel : this.parameterizedModel.getParameterGroupModels()) {
                Optional modelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class);
                if (!modelProperty.isPresent()) continue;
                ParameterGroupModelProperty property = (ParameterGroupModelProperty)modelProperty.get();
                Field container = (Field)property.getDescriptor().getContainer();
                Object parameterGroup = IntrospectionUtils.getFieldValue(this.object, container.getName(), this.reflectionCache);
                Optional<Field> desiredField = IntrospectionUtils.getField(parameterGroup.getClass(), parameterName, this.reflectionCache);
                if (desiredField.isPresent()) {
                    return IntrospectionUtils.getFieldValue(parameterGroup, parameterName, this.reflectionCache);
                }
                if (!parameterGroupModel.getName().equals(parameterName)) continue;
                returnValue = parameterGroup;
            }
            if (returnValue != null) {
                return returnValue;
            }
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to obtain the value for the parameter: " + parameterName);
        }
        throw new ValueResolvingException("Unable to resolve value for the parameter: " + parameterName);
    }

    @Override
    public Map<String, ValueResolver<? extends Object>> getParameters() throws ValueResolvingException {
        HashMap<String, ValueResolver<? extends Object>> parameters = new HashMap<String, ValueResolver<? extends Object>>();
        try {
            this.addFields(IntrospectionUtils.getFields(this.object.getClass()), parameters);
            for (ParameterGroupModel parameterGroupModel : this.parameterizedModel.getParameterGroupModels()) {
                Optional modelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class);
                if (!modelProperty.isPresent()) continue;
                ParameterGroupModelProperty property = (ParameterGroupModelProperty)modelProperty.get();
                Field container = (Field)property.getDescriptor().getContainer();
                Object parameterGroup = IntrospectionUtils.getFieldValue(this.object, container.getName(), this.reflectionCache);
                this.addFields(IntrospectionUtils.getFields(parameterGroup.getClass()), parameters);
            }
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to obtain the parameters.");
        }
        return Collections.unmodifiableMap(parameters);
    }

    private void addFields(List<Field> fields, HashMap<String, ValueResolver<? extends Object>> parameters) throws NoSuchFieldException, IllegalAccessException {
        for (Field field : fields) {
            String parameterName = field.getName();
            parameters.put(parameterName, new StaticValueResolver<Object>(IntrospectionUtils.getFieldValue(this.object, parameterName, this.reflectionCache)));
        }
    }
}

