/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.Optional;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ComponentMessageProcessorTestCase
extends AbstractMuleContextTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessorTestCase.class);
    private ComponentMessageProcessor<ComponentModel> processor;
    private ExtensionModel extensionModel;
    private ComponentModel componentModel;
    private ResolverSet resolverSet;
    private ExtensionManager extensionManager;
    private PolicyManager mockPolicyManager;
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @Before
    public void before() throws MuleException {
        CoreEvent response = this.testEvent();
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("mock").build());
        this.componentModel = (ComponentModel)Mockito.mock(ComponentModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{EnrichableModel.class}));
        Mockito.when((Object)this.componentModel.getModelProperty(CompletableComponentExecutorModelProperty.class)).thenReturn(Optional.of(new CompletableComponentExecutorModelProperty((cp, p) -> (ctx, callback) -> callback.complete((Object)response))));
        this.resolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        this.extensionManager = (ExtensionManager)Mockito.mock(ExtensionManager.class);
        this.mockPolicyManager = (PolicyManager)Mockito.mock(PolicyManager.class);
        this.processor = new ComponentMessageProcessor<ComponentModel>(this.extensionModel, this.componentModel, null, null, null, this.resolverSet, null, null, this.extensionManager, this.mockPolicyManager, null, null, muleContext.getConfiguration().getShutdownTimeout()){

            protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
            }

            public ReactiveProcessor.ProcessingType getInnerProcessingType() {
                return ReactiveProcessor.ProcessingType.CPU_LITE;
            }
        };
        this.processor.setComponentLocator(this.componentLocator);
        this.processor.setCacheIdGeneratorFactory((MetadataCacheIdGeneratorFactory)Mockito.mock(MetadataCacheIdGeneratorFactory.class));
        LifecycleUtils.initialiseIfNeeded(this.processor, (MuleContext)muleContext);
        LifecycleUtils.startIfNeeded(this.processor);
    }

    @After
    public void after() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processor);
        LifecycleUtils.disposeIfNeeded(this.processor, (Logger)LOGGER);
    }

    @Test
    public void happyPath() throws MuleException {
        ResolverSetResult resolverSetResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class);
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)resolverSetResult);
        Assert.assertNotNull((Object)Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block());
    }

    @Test
    public void muleRuntimeExceptionInResolutionResult() throws MuleException {
        ExpressionRuntimeException thrown = new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped((Exception)thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void muleExceptionInResolutionResult() throws MuleException {
        DefaultMuleException thrown = new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Expected"));
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped((Exception)thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    @Test
    public void runtimeExceptionInResolutionResult() throws MuleException {
        NullPointerException thrown = new NullPointerException("Expected");
        Mockito.when((Object)this.resolverSet.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenThrow(new Throwable[]{thrown});
        this.expectWrapped(thrown);
        Mono.from((Publisher)this.processor.apply((Publisher)Mono.just((Object)this.testEvent()))).block();
    }

    private void expectWrapped(final Exception expect) {
        this.expected.expect((Matcher)new BaseMatcher<Exception>(){

            public boolean matches(Object o) {
                Exception e = (Exception)Exceptions.unwrap((Throwable)((Exception)o));
                Assert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MessagingException.class)));
                Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)expect)));
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("condition not met");
            }
        });
    }
}

