/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultMutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.TestTimeSupplier;

@SmallTest
public class DefaultMutableConfigurationStatsTestCase
extends AbstractMuleTestCase {
    private TestTimeSupplier timeSupplier = new TestTimeSupplier(System.currentTimeMillis());
    private MutableConfigurationStats stats = new DefaultMutableConfigurationStats((TimeSupplier)this.timeSupplier);

    @Test
    public void lastUsed() {
        Assert.assertThat((Object)this.stats.getLastUsedMillis(), (Matcher)CoreMatchers.is((Object)this.timeSupplier.get()));
    }

    @Test
    public void updateLastUsed() {
        this.lastUsed();
        long now = this.timeSupplier.move(1L, TimeUnit.MINUTES);
        Assert.assertThat((Object)(this.stats.getLastUsedMillis() + 60000L), (Matcher)CoreMatchers.is((Object)now));
        this.stats.updateLastUsed();
        Assert.assertThat((Object)this.stats.getLastUsedMillis(), (Matcher)CoreMatchers.is((Object)now));
    }

    @Test
    public void inflightOperations() {
        Assert.assertThat((Object)this.stats.getInflightOperations(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.stats.addInflightOperation(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.stats.getInflightOperations(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.stats.discountInflightOperation(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.stats.getInflightOperations(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void runningSources() {
        Assert.assertThat((Object)this.stats.getRunningSources(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.stats.addRunningSource(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.stats.getRunningSources(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)this.stats.discountRunningSource(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)this.stats.getRunningSources(), (Matcher)CoreMatchers.is((Object)0));
    }
}

