/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.config.ImmutableExpirationPolicy;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.runtime.module.extension.internal.runtime.config.AbstractConfigurationProviderTestCase;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class DynamicConfigurationProviderTestCase
extends AbstractConfigurationProviderTestCase<HeisenbergExtension> {
    private static final Class MODULE_CLASS = HeisenbergExtension.class;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().silent();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Mock
    private ResolverSet resolverSet;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ResolverSetResult resolverSetResult;
    @Mock
    private ConnectionProviderResolver connectionProviderResolver;
    @Mock
    private ExpressionManager expressionManager;
    private ExpirationPolicy expirationPolicy;

    @Override
    @Before
    public void before() throws Exception {
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getConfigurationModels()).thenReturn(Arrays.asList(this.configurationModel));
        Mockito.when((Object)this.operationModel.requiresConnection()).thenReturn((Object)true);
        Mockito.when((Object)this.configurationModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.configurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.expressionManager.openSession((BindingContext)ArgumentMatchers.any())).thenReturn(Mockito.mock(ExpressionManagerSession.class));
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build();
        Mockito.when((Object)this.resolverSet.resolve(ctx)).thenReturn((Object)this.resolverSetResult);
        Mockito.when((Object)this.resolverSetResult.asMap()).thenReturn(new HashMap());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel});
        this.expirationPolicy = new ImmutableExpirationPolicy(5L, TimeUnit.MINUTES, (TimeSupplier)this.timeSupplier);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.empty());
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)ArgumentMatchers.any())).thenReturn(null);
        muleContext.setExtensionManager((ExtensionManager)new DefaultExtensionManager());
        this.provider = new DynamicConfigurationProvider("config", this.extensionModel, this.configurationModel, this.resolverSet, (ConnectionProviderValueResolver)this.connectionProviderResolver, this.expirationPolicy, new ReflectionCache(), this.expressionManager, muleContext);
        super.before();
        this.provider.initialise();
        this.provider.start();
    }

    @After
    public void after() throws MuleException {
        this.stopIfNecessary();
        this.disposeIfNecessary();
    }

    private void disposeIfNecessary() {
        if (this.isValidTransition("dispose")) {
            this.provider.dispose();
        }
    }

    private void stopIfNecessary() throws MuleException {
        if (this.isValidTransition("stop")) {
            this.provider.stop();
        }
    }

    private boolean isValidTransition(String phaseName) {
        return this.provider.lifecycleManager.getState().isValidTransition(phaseName);
    }

    @Test
    public void resolveCached() throws Exception {
        int count = 10;
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)config)));
        }
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build();
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ctx);
    }

    @Test
    public void resolveCachedWithProviderParams() throws Exception {
        ResolverSet providerResolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.of(providerResolverSet));
        Mockito.when((Object)this.connectionProviderResolver.getObjectBuilder()).thenReturn(Optional.empty());
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build();
        Mockito.when((Object)providerResolverSet.resolve(ctx)).thenReturn((Object)this.resolverSetResult);
        int count = 10;
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        for (int i = 1; i < 10; ++i) {
            Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)config)));
        }
        ((ResolverSet)Mockito.verify((Object)providerResolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build());
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)10))).resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build());
    }

    @Test
    public void resolveProviderParamsDifferentInstance() throws Exception {
        HeisenbergExtension config = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        ResolverSet providerResolverSet = (ResolverSet)Mockito.mock(ResolverSet.class);
        Mockito.when((Object)this.connectionProviderResolver.getResolverSet()).thenReturn(Optional.of(providerResolverSet));
        Mockito.when((Object)this.connectionProviderResolver.getObjectBuilder()).thenReturn(Optional.empty());
        Mockito.when((Object)providerResolverSet.resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build())).thenReturn(Mockito.mock(ResolverSetResult.class));
        Assert.assertThat((Object)this.provider.get((Event)this.event).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)config))));
        ((ResolverSet)Mockito.verify((Object)this.resolverSet, (VerificationMode)Mockito.times((int)2))).resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build());
        ((ResolverSet)Mockito.verify((Object)providerResolverSet, (VerificationMode)Mockito.times((int)1))).resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build());
        ((ConnectionProviderResolver)Mockito.verify((Object)this.connectionProviderResolver, (VerificationMode)Mockito.times((int)2))).resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build());
    }

    @Test
    public void resolveDifferentInstances() throws Exception {
        HeisenbergExtension instance1 = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        HeisenbergExtension instance2 = this.makeAlternateInstance();
        Assert.assertThat((Object)instance2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)instance1))));
    }

    @Test
    public void getExpired() throws Exception {
        HeisenbergExtension instance1 = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        HeisenbergExtension instance2 = this.makeAlternateInstance();
        DynamicConfigurationProvider provider = (DynamicConfigurationProvider)this.provider;
        this.timeSupplier.move(1L, TimeUnit.MINUTES);
        List expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        this.timeSupplier.move(10L, TimeUnit.MINUTES);
        expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        List configs = (List)expired.stream().map(ConfigurationInstance::getValue).collect(Collectors.toImmutableList());
        Assert.assertThat((Object)configs, (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{instance1, instance2}));
    }

    @Test
    public void configurationInstanceIsRemovedFromLifecycleTrackingAfterExpired() throws Exception {
        HeisenbergExtension instance = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        DynamicConfigurationProvider provider = (DynamicConfigurationProvider)this.provider;
        this.timeSupplier.move(10L, TimeUnit.MINUTES);
        List expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
        provider.stop();
        provider.dispose();
        Assert.assertThat((Object)instance.getStop(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)instance.getDispose(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void configurationInstanceFollowsLifecycleTrakingWhenNotExpired() throws Exception {
        HeisenbergExtension instance = (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
        DynamicConfigurationProvider provider = (DynamicConfigurationProvider)this.provider;
        this.timeSupplier.move(1L, TimeUnit.MINUTES);
        List expired = provider.getExpired();
        Assert.assertThat((Object)expired.isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        provider.stop();
        provider.dispose();
        Assert.assertThat((Object)instance.getStop(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)instance.getDispose(), (Matcher)CoreMatchers.is((Object)1));
    }

    private HeisenbergExtension makeAlternateInstance() throws Exception {
        ResolverSetResult alternateResult = (ResolverSetResult)Mockito.mock(ResolverSetResult.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)alternateResult.asMap()).thenReturn(new HashMap());
        ExtensionsTestUtils.mockConfigurationInstance(this.configurationModel, MODULE_CLASS.newInstance());
        Mockito.when((Object)this.resolverSet.resolve(ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build())).thenReturn((Object)alternateResult);
        return (HeisenbergExtension)this.provider.get((Event)this.event).getValue();
    }

    @Test
    public void resolveDynamicConfigWithEquivalentEvent() throws Exception {
        this.assertSameInstancesResolved();
    }

    @Test
    public void resolveDynamicConfigWithDifferentEvent() throws Exception {
        ConfigurationInstance config1 = this.provider.get((Event)this.event);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)this.event).withExpressionManager(this.expressionManager).build();
        Mockito.when((Object)this.resolverSet.resolve(ctx)).thenReturn(Mockito.mock(ResolverSetResult.class));
        ConfigurationInstance config2 = this.provider.get((Event)this.event);
        Assert.assertThat((Object)config1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)config2))));
    }

    @Test
    public void configFailsOnInitialize() throws Exception {
        Lifecycle connProvider = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ConnectionProvider.class}));
        String expectedExceptionMessage = "Init failed!";
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Init failed!")}).when((Object)connProvider)).initialise();
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)ArgumentMatchers.any())).thenReturn((Object)new Pair((Object)connProvider, Mockito.mock(ResolverSetResult.class)));
        this.expected.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.is((Object)(InitialisationException.class.getName() + ": " + "Init failed!"))));
        try {
            this.provider.get((Event)this.event);
        }
        finally {
            ((Lifecycle)Mockito.verify((Object)connProvider)).initialise();
            ((Lifecycle)Mockito.verify((Object)connProvider, (VerificationMode)Mockito.never())).start();
            ((Lifecycle)Mockito.verify((Object)connProvider, (VerificationMode)Mockito.never())).stop();
            ((Lifecycle)Mockito.verify((Object)connProvider)).dispose();
        }
    }

    @Test
    public void configFailsOnStart() throws Exception {
        Lifecycle connProvider = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ConnectionProvider.class}));
        RuntimeException toThrow = new RuntimeException("Start failed!");
        ((Lifecycle)Mockito.doThrow((Throwable[])new Throwable[]{toThrow}).when((Object)connProvider)).start();
        Mockito.when((Object)this.connectionProviderResolver.resolve((ValueResolvingContext)ArgumentMatchers.any())).thenReturn((Object)new Pair((Object)connProvider, (Object)this.resolverSetResult));
        this.expected.expectCause(CoreMatchers.sameInstance((Object)toThrow));
        try {
            this.provider.get((Event)this.event);
        }
        finally {
            ((Lifecycle)Mockito.verify((Object)connProvider)).initialise();
            ((Lifecycle)Mockito.verify((Object)connProvider)).start();
            ((Lifecycle)Mockito.verify((Object)connProvider)).stop();
            ((Lifecycle)Mockito.verify((Object)connProvider)).dispose();
        }
    }
}

