/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PlatformManagedOAuthConfigTestCase
extends AbstractMuleTestCase {
    private static final String CLIENT_ID = "client_id";
    private static final String SECRET_ID = "secret_id";
    private static final String ORG_ID = "org_id";
    private static final String SERVICE_URL = "service_url";
    private static final String PLATFORM_AUTH_URL = "http://localhost/accounts";
    private static final String PLATFORM_AUTH_PATH = "/token";
    private ConfigurationProperties configurationProperties;

    @Before
    public void before() {
        this.configurationProperties = (ConfigurationProperties)Mockito.mock(ConfigurationProperties.class);
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.client.secret")).thenReturn(Optional.of(SECRET_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.client.id")).thenReturn(Optional.of(CLIENT_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("csorganization.id")).thenReturn(Optional.of(ORG_ID));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.service.url")).thenReturn(Optional.of(SERVICE_URL));
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.platform.authentication.url")).thenReturn(Optional.of(PLATFORM_AUTH_URL));
    }

    @Test
    public void getPlatformAuthUrl() {
        PlatformManagedOAuthConfig config = PlatformManagedOAuthConfig.from((String)"", (String)"", null, null, null, null, (ConfigurationProperties)this.configurationProperties);
        Assert.assertThat((Object)config.getPlatformAuthUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost/accounts/oauth2/token"));
    }

    @Test
    public void getPlatformAuthUrlWithPath() {
        Mockito.when((Object)this.configurationProperties.resolveStringProperty("ocs.platform.authentication.path")).thenReturn(Optional.of(PLATFORM_AUTH_PATH));
        PlatformManagedOAuthConfig config = PlatformManagedOAuthConfig.from((String)"", (String)"", null, null, null, null, (ConfigurationProperties)this.configurationProperties);
        Assert.assertThat((Object)config.getPlatformAuthUrl(), (Matcher)CoreMatchers.equalTo((Object)"http://localhost/accounts/token"));
    }
}

