/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SdkInternalContextTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="MULE-18189")
    @Description(value="scatter-gather sends the same event to different routes. In that case, the relationship of what context belongs to the operation on what route must be kept.")
    public void contextSharedOnParallelRoutes() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        DefaultComponentLocation comp1 = DefaultComponentLocation.fromSingleComponent((String)"comp1");
        DefaultComponentLocation comp2 = DefaultComponentLocation.fromSingleComponent((String)"comp2");
        ArrayList<Pair<ComponentLocation, String>> completedForComponents = new ArrayList<Pair<ComponentLocation, String>>();
        this.pushContext(ctx, (ComponentLocation)comp1, "event1", completedForComponents);
        this.pushContext(ctx, (ComponentLocation)comp2, "event1", completedForComponents);
        ctx.getOperationExecutionParams((ComponentLocation)comp1, "event1").getCallback().complete((Object)comp1);
        ctx.getOperationExecutionParams((ComponentLocation)comp2, "event1").getCallback().complete((Object)comp2);
        Assert.assertThat(completedForComponents, (Matcher)Matchers.contains((Object[])new Pair[]{new Pair((Object)comp1, (Object)"event1"), new Pair((Object)comp2, (Object)"event1")}));
    }

    @Test
    @Issue(value="MULE-18227")
    @Description(value="parallel-foreach sends differenr events to the same routes. In that case, the relationship of what context belongs to the operation on what route must be kept.")
    public void contextSharedOnParallelEvents() throws MuleException {
        SdkInternalContext ctx = new SdkInternalContext();
        DefaultComponentLocation comp1 = DefaultComponentLocation.fromSingleComponent((String)"comp1");
        ArrayList<Pair<ComponentLocation, String>> completedForComponents = new ArrayList<Pair<ComponentLocation, String>>();
        this.pushContext(ctx, (ComponentLocation)comp1, "event1", completedForComponents);
        this.pushContext(ctx, (ComponentLocation)comp1, "event2", completedForComponents);
        ctx.getOperationExecutionParams((ComponentLocation)comp1, "event1").getCallback().complete((Object)comp1);
        ctx.getOperationExecutionParams((ComponentLocation)comp1, "event2").getCallback().complete((Object)comp1);
        Assert.assertThat(completedForComponents, (Matcher)Matchers.contains((Object[])new Pair[]{new Pair((Object)comp1, (Object)"event1"), new Pair((Object)comp1, (Object)"event2")}));
    }

    private void pushContext(SdkInternalContext ctx, final ComponentLocation location, final String eventId, final List<Pair<ComponentLocation, String>> completedForComponents) throws MuleException {
        ctx.putContext(location, eventId);
        ctx.setOperationExecutionParams(location, eventId, Optional.empty(), Collections.emptyMap(), this.testEvent(), new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                completedForComponents.add(new Pair((Object)location, (Object)eventId));
            }

            public void error(Throwable e) {
                throw new MuleRuntimeException(e);
            }
        });
    }
}

