/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.factory.InMemoryCursorStreamProviderFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.SimpleByteBufferManager;
import org.mule.runtime.core.internal.util.message.ResultsToMessageList;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public abstract class ValueReturnDelegateContractTestCase
extends AbstractMuleContextTestCase {
    public static final String HELLO_WORLD_MSG = "Hello world!";
    @Mock(lenient=true)
    protected ExecutionContextAdapter operationContext;
    @Mock
    protected ConnectableComponentModel componentModel;
    protected CoreEvent event;
    @Mock
    protected Object attributes;
    @Mock(lenient=true)
    protected OutputModel outputModel;
    @Mock
    protected ConnectionHandler connectionHandler;
    protected ReturnDelegate delegate;
    protected ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    protected DefaultStreamingManager streamingManager;

    @Before
    public void before() throws MuleException {
        this.streamingManager = new DefaultStreamingManager();
        LifecycleUtils.initialiseIfNeeded((Object)this.streamingManager, (MuleContext)muleContext);
        this.event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.builder().value((Object)"").attributesValue(this.attributes).build()).build();
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build());
        Mockito.when((Object)this.outputModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.outputModel.getModelProperties()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.outputModel.getDescription()).thenReturn((Object)"");
        Mockito.when((Object)this.componentModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.componentModel.getOutput()).thenReturn((Object)this.outputModel);
        this.delegate = this.createReturnDelegate();
        Mockito.when((Object)this.operationContext.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.operationContext.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)this.operationContext.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.operationContext.getVariable(ArgumentMatchers.contains((String)"MULE_CONNECTION_PARAM"))).thenReturn((Object)this.connectionHandler);
    }

    @After
    public void tearDown() throws Exception {
        this.disposeStreamingManager();
    }

    @Test
    public void returnsSingleValue() {
        byte[] value = new byte[]{};
        CoreEvent result = this.delegate.asReturnValue((Object)value, this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(byte[].class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultButKeepsAttributes() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)muleContext));
        CoreEvent result = this.delegate.asReturnValue((Object)Result.builder().output(payload).mediaType(mediaType).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayload() throws Exception {
        String payload = "hello world!";
        CoreEvent result = this.delegate.asReturnValue((Object)Result.builder().output((Object)payload).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayloadAndAttributes() throws Exception {
        String payload = "hello world!";
        Object newAttributes = Mockito.mock(Object.class);
        CoreEvent result = this.delegate.asReturnValue((Object)Result.builder().output((Object)payload).attributes(newAttributes).build(), this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)newAttributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationWithDefaultMimeType() throws Exception {
        Mockito.when((Object)this.componentModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.of(new MediaTypeModelProperty(MediaType.APPLICATION_JSON.toRfcString(), true)));
        this.delegate = this.createReturnDelegate();
        String value = HELLO_WORLD_MSG;
        CoreEvent result = this.delegate.asReturnValue((Object)value, this.operationContext);
        Message message = this.getOutputMessage(result);
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType().toRfcString(), (Matcher)CoreMatchers.containsString((String)MediaType.APPLICATION_JSON.toRfcString()));
    }

    @Test
    public void operationWithPlainInputStreamOutput() throws Exception {
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.typeLoader.load(InputStream.class));
        Mockito.when((Object)this.componentModel.supportsStreaming()).thenReturn((Object)true);
        this.assertStreamIsWrapped(new ByteArrayInputStream(HELLO_WORLD_MSG.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void operationWithResultInputStreamOutput() throws Exception {
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.typeLoader.load(InputStream.class));
        Mockito.when((Object)this.componentModel.supportsStreaming()).thenReturn((Object)true);
        this.assertStreamIsWrapped(Result.builder().output((Object)new ByteArrayInputStream(HELLO_WORLD_MSG.getBytes(StandardCharsets.UTF_8))).build());
    }

    @Test
    public void operationWithResultInputStreamCollectionOutput() throws Exception {
        ArrayType metadataType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of((MetadataType)new MessageMetadataTypeBuilder().build()).build();
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)metadataType);
        Mockito.when((Object)this.componentModel.supportsStreaming()).thenReturn((Object)true);
        this.delegate = this.createReturnDelegate();
        ArrayList<Result> resultList = new ArrayList<Result>();
        resultList.add(Result.builder().output((Object)new ByteArrayInputStream(HELLO_WORLD_MSG.getBytes(StandardCharsets.UTF_8))).build());
        CoreEvent result = this.delegate.asReturnValue(resultList, this.operationContext);
        Message message = this.getOutputMessage(result);
        Message message1 = ((ResultsToMessageList)message.getPayload().getValue()).get(0);
        ManagedCursorStreamProvider actual = (ManagedCursorStreamProvider)message1.getPayload().getValue();
        InputStream resultingStream = (InputStream)actual.openCursor();
        Assert.assertThat((Object)IOUtils.toString((InputStream)resultingStream), (Matcher)CoreMatchers.is((Object)HELLO_WORLD_MSG));
        resultingStream.close();
        actual.releaseResources();
        this.disposeStreamingManager();
        PollingProber.probe((long)5000L, (long)500L, () -> {
            ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler, (VerificationMode)Mockito.atLeastOnce())).release();
            return true;
        });
    }

    @Test
    public void operationWithResultInputStreamOutputReleasesConnection() throws Exception {
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.typeLoader.load(InputStream.class));
        Mockito.when((Object)this.componentModel.supportsStreaming()).thenReturn((Object)true);
        this.delegate = this.createReturnDelegate();
        Result inputStreamResult = Result.builder().output((Object)new ByteArrayInputStream(HELLO_WORLD_MSG.getBytes(StandardCharsets.UTF_8))).build();
        CoreEvent result = this.delegate.asReturnValue((Object)inputStreamResult, this.operationContext);
        Message message = this.getOutputMessage(result);
        ManagedCursorStreamProvider cursorStreamProvider = (ManagedCursorStreamProvider)message.getPayload().getValue();
        InputStream resultingStream = (InputStream)cursorStreamProvider.openCursor();
        Assert.assertThat((Object)IOUtils.toString((InputStream)resultingStream), (Matcher)CoreMatchers.is((Object)HELLO_WORLD_MSG));
        ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler, (VerificationMode)Mockito.atLeastOnce())).release();
    }

    private void assertStreamIsWrapped(Object value) throws InitialisationException, IOException {
        this.delegate = this.createReturnDelegate();
        CoreEvent result = this.delegate.asReturnValue(value, this.operationContext);
        Message message = this.getOutputMessage(result);
        ManagedCursorStreamProvider actual = (ManagedCursorStreamProvider)message.getPayload().getValue();
        InputStream resultingStream = (InputStream)actual.openCursor();
        Assert.assertThat((Object)IOUtils.toString((InputStream)resultingStream), (Matcher)CoreMatchers.is((Object)HELLO_WORLD_MSG));
        resultingStream.close();
        actual.releaseResources();
        this.disposeStreamingManager();
        PollingProber.probe((long)5000L, (long)500L, () -> {
            ((ConnectionHandler)Mockito.verify((Object)this.connectionHandler, (VerificationMode)Mockito.atLeastOnce())).release();
            return true;
        });
    }

    private void disposeStreamingManager() {
        if (this.streamingManager != null) {
            this.streamingManager.dispose();
            this.streamingManager = null;
        }
    }

    protected InMemoryCursorStreamProviderFactory getCursorProviderFactory() {
        return new InMemoryCursorStreamProviderFactory((ByteBufferManager)new SimpleByteBufferManager(), InMemoryCursorStreamConfig.getDefault(), (StreamingManager)this.streamingManager);
    }

    protected abstract ReturnDelegate createReturnDelegate() throws InitialisationException;

    protected abstract Message getOutputMessage(CoreEvent var1);
}

