/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.processor.ParametersResolverProcessor;
import org.mule.runtime.core.internal.processor.strategy.OperationInnerProcessor;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.FluxSinkSupplier;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.ChainErrorHandlingUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionInterceptor;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.SdkInternalContext;
import org.mule.runtime.module.extension.internal.runtime.execution.interceptor.InterceptorChain;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PayloadTargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.streaming.CursorResetInterceptor;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public abstract class ComponentMessageProcessor<T extends ComponentModel>
extends ExtensionComponent<T>
implements Processor,
ParametersResolverProcessor<T>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentMessageProcessor.class);
    private static final ExtensionTransactionFactory TRANSACTION_FACTORY = new ExtensionTransactionFactory();
    static final String INVALID_TARGET_MESSAGE = "Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s";
    private final ReflectionCache reflectionCache;
    private final DefaultExecutionMediator.ResultTransformer resultTransformer;
    private final RetryPolicyTemplate fallbackRetryPolicyTemplate = new NoRetryPolicyTemplate();
    protected final ExtensionModel extensionModel;
    private final boolean hasNestedChain;
    protected final ResolverSet resolverSet;
    protected final String target;
    protected final String targetValue;
    protected final RetryPolicyTemplate retryPolicyTemplate;
    private Optional<TransactionConfig> transactionConfig;
    private final long outerFluxTerminationTimeout;
    private final Object fluxSupplierDisposeLock = new Object();
    private final AtomicInteger activeOuterPublishersCount = new AtomicInteger(0);
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private ExtensionConnectionSupplier extensionConnectionSupplier;
    private Function<Optional<ConfigurationInstance>, RetryPolicyTemplate> retryPolicyResolver;
    private String resolvedProcessorRepresentation;
    private boolean initialised = false;
    private ProcessingStrategy processingStrategy;
    private boolean ownedProcessingStrategy = false;
    private FluxSinkSupplier<CoreEvent> fluxSupplier;
    private Scheduler outerFluxCompletionScheduler;
    protected ExecutionMediator executionMediator;
    protected CompletableComponentExecutor componentExecutor;
    protected ReturnDelegate returnDelegate;
    protected PolicyManager policyManager;

    public ComponentMessageProcessor(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache, DefaultExecutionMediator.ResultTransformer resultTransformer, long terminationTimeout) {
        super(extensionModel, componentModel, configurationProvider, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.targetValue = targetValue;
        this.policyManager = policyManager;
        this.retryPolicyTemplate = retryPolicyTemplate;
        this.reflectionCache = reflectionCache;
        this.resultTransformer = resultTransformer;
        this.hasNestedChain = this.hasNestedChain(componentModel);
        this.outerFluxTerminationTimeout = terminationTimeout;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply((CoreEvent)event, (ReactiveProcessor)this);
    }

    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        BiFunction localOperatorErrorHook = ChainErrorHandlingUtils.getLocalOperatorErrorHook((Processor)this, (ErrorTypeLocator)this.errorTypeLocator, this.exceptionContextProviders);
        boolean async = this.isAsync();
        ComponentLocation location = this.getLocation();
        return Mono.subscriberContext().flatMapMany(ctx -> {
            Flux transformed = this.createOuterFlux((Flux<CoreEvent>)Flux.from((Publisher)publisher), localOperatorErrorHook, async, (Context)ctx).doOnNext(result -> result.apply(me -> {
                CoreEvent event = ((MessagingException)me).getEvent();
                SdkInternalContext sdkCtx = SdkInternalContext.from(event);
                if (sdkCtx != null) {
                    sdkCtx.removeContext(location, event.getContext().getId());
                }
            }, response -> {
                SdkInternalContext sdkCtx = SdkInternalContext.from(response);
                if (sdkCtx != null) {
                    sdkCtx.removeContext(location, response.getContext().getId());
                }
            })).map(result -> (CoreEvent)result.reduce(me -> {
                throw Exceptions.propagateWrappingFatal((Throwable)me);
            }, response -> response));
            if (publisher instanceof Flux && !ctx.getOrEmpty((Object)"messageProcessors.withinProcessToApply").isPresent()) {
                return transformed.doAfterTerminate(this::outerPublisherTerminated).doOnSubscribe(s -> this.outerPublisherSubscribedTo());
            }
            return transformed;
        });
    }

    private Flux<Either<Throwable, CoreEvent>> createOuterFlux(Flux<CoreEvent> publisher, final BiFunction<Throwable, Object, Throwable> localOperatorErrorHook, boolean async, Context ctx) {
        final FluxSinkRecorder errorSwitchSinkSinkRef = new FluxSinkRecorder();
        Function<Publisher, Publisher> transformer = pub -> Flux.from((Publisher)pub).map(event -> {
            try {
                return this.addContextToEvent((CoreEvent)event, ctx);
            }
            catch (Exception t) {
                Throwable mapped = (Throwable)localOperatorErrorHook.apply(t, event);
                if (this.outerFluxTerminationTimeout < 0L || ((Boolean)ctx.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
                    errorSwitchSinkSinkRef.next((Object)Either.left((Object)mapped, CoreEvent.class));
                }
                throw Exceptions.propagateWrappingFatal((Throwable)mapped);
            }
        }).doOnNext(event -> {
            CompletableComponentExecutor.ExecutorCallback executorCallback = new CompletableComponentExecutor.ExecutorCallback((CoreEvent)event){
                final /* synthetic */ CoreEvent val$event;
                {
                    this.val$event = coreEvent;
                }

                public void error(Throwable e) {
                    errorSwitchSinkSinkRef.next((Object)Either.left(localOperatorErrorHook.apply(e, this.val$event), CoreEvent.class));
                }

                public void complete(Object value) {
                    errorSwitchSinkSinkRef.next((Object)Either.right(Throwable.class, (Object)((CoreEvent)value)));
                }
            };
            if (!async && SdkInternalContext.from(event).isNoPolicyOperation(this.getLocation(), event.getContext().getId())) {
                this.onEventSynchronous((CoreEvent)event, executorCallback, ctx);
            } else {
                this.onEvent((CoreEvent)event, executorCallback);
            }
        }).map(e -> Either.empty());
        if (this.outerFluxTerminationTimeout < 0L || ((Boolean)ctx.getOrDefault((Object)"messageProcessors.withinProcessToApply", (Object)false)).booleanValue()) {
            return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from(publisher), (Publisher)errorSwitchSinkSinkRef.flux(), transformer, () -> errorSwitchSinkSinkRef.complete(), t -> errorSwitchSinkSinkRef.error(t)));
        }
        return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from(publisher), (Publisher)errorSwitchSinkSinkRef.flux(), transformer, () -> errorSwitchSinkSinkRef.complete(), t -> errorSwitchSinkSinkRef.error(t), (long)this.outerFluxTerminationTimeout, (ScheduledExecutorService)this.outerFluxCompletionScheduler));
    }

    public ReactiveProcessor.ProcessingType getProcessingType() {
        if (this.isAsync()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE;
        }
        return this.getInnerProcessingType();
    }

    private void onEvent(CoreEvent event, CompletableComponentExecutor.ExecutorCallback executorCallback) {
        try {
            SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
            ComponentLocation location = this.getLocation();
            String eventId = event.getContext().getId();
            Optional<ConfigurationInstance> configuration = sdkInternalContext.getConfiguration(location, eventId);
            Map<String, Object> resolutionResult = sdkInternalContext.getResolutionResult(location, eventId);
            OperationExecutionFunction operationExecutionFunction = (parameters, operationEvent, callback) -> {
                sdkInternalContext.setOperationExecutionParams(location, eventId, configuration, parameters, operationEvent, callback);
                ((FluxSink)this.fluxSupplier.get()).next((Object)operationEvent);
            };
            if (location != null) {
                ((DefaultFlowCallStack)event.getFlowCallStack()).setCurrentProcessorPath(this.resolvedProcessorRepresentation);
                sdkInternalContext.getPolicyToApply(location, eventId).process(event, operationExecutionFunction, () -> resolutionResult, location, executorCallback);
            } else {
                operationExecutionFunction.execute(resolutionResult, event, executorCallback);
            }
        }
        catch (Throwable t) {
            executorCallback.error(Exceptions.unwrap((Throwable)t));
        }
    }

    private void onEventSynchronous(CoreEvent event, CompletableComponentExecutor.ExecutorCallback executorCallback, Context ctx) {
        try {
            SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
            ComponentLocation location = this.getLocation();
            String eventId = event.getContext().getId();
            Optional<ConfigurationInstance> configuration = sdkInternalContext.getConfiguration(location, eventId);
            Map<String, Object> resolutionResult = sdkInternalContext.getResolutionResult(location, eventId);
            OperationExecutionFunction operationExecutionFunction = (parameters, operationEvent, callback) -> {
                sdkInternalContext.setOperationExecutionParams(location, eventId, configuration, parameters, operationEvent, callback);
                this.prepareAndExecuteOperation(event, () -> callback, ctx);
            };
            operationExecutionFunction.execute(resolutionResult, event, executorCallback);
        }
        catch (Throwable t) {
            executorCallback.error(Exceptions.unwrap((Throwable)t));
        }
    }

    private CompletableComponentExecutor.ExecutorCallback mapped(final CompletableComponentExecutor.ExecutorCallback callback, final ExecutionContextAdapter<T> operationContext) {
        return new CompletableComponentExecutor.ExecutorCallback(){

            public void complete(Object value) {
                callback.complete((Object)ComponentMessageProcessor.this.returnDelegate.asReturnValue(value, operationContext));
            }

            public void error(Throwable t) {
                callback.error(Exceptions.unwrap((Throwable)t));
            }
        };
    }

    private Optional<ConfigurationInstance> resolveConfiguration(CoreEvent event) {
        if (this.shouldUsePrecalculatedContext(event)) {
            return this.getPrecalculatedContext(event).getConfiguration();
        }
        return this.getConfiguration(event);
    }

    private boolean shouldUsePrecalculatedContext(CoreEvent event) {
        ComponentLocation location = this.getLocation();
        return location != null && this.isInterceptedComponent(location, (InternalEvent)event) && this.getPrecalculatedContext(event) != null;
    }

    private PrecalculatedExecutionContextAdapter<T> getPrecalculatedContext(CoreEvent event) {
        return (PrecalculatedExecutionContextAdapter)((InternalEvent)event).getInternalParameter("core:interceptionResolvedContext");
    }

    protected void executeOperation(ExecutionContextAdapter<T> operationContext, CompletableComponentExecutor.ExecutorCallback callback) {
        this.executionMediator.execute(this.componentExecutor, operationContext, callback);
    }

    private ExecutionContextAdapter<T> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, CoreEvent event, Scheduler currentScheduler) {
        return new DefaultExecutionContext<ComponentModel>(this.extensionModel, configuration, resolvedParameters, this.componentModel, event, this.getCursorProviderFactory(), this.streamingManager, (Component)this, this.getRetryPolicyTemplate(configuration), currentScheduler, this.transactionConfig, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (!this.initialised) {
            this.initRetryPolicyResolver();
            try {
                this.transactionConfig = this.buildTransactionConfig();
            }
            catch (MuleException e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Could not resolve transactional configuration"), (Throwable)e, (Initialisable)this);
            }
            this.returnDelegate = this.createReturnDelegate();
            LifecycleUtils.initialiseIfNeeded((Object)this.resolverSet, (MuleContext)this.muleContext);
            this.componentExecutor = this.createComponentExecutor();
            this.executionMediator = this.createExecutionMediator();
            LifecycleUtils.initialiseIfNeeded((Object)this.componentExecutor, (boolean)true, (MuleContext)this.muleContext);
            this.resolvedProcessorRepresentation = this.getRepresentation();
            this.initProcessingStrategy();
            this.initialised = true;
        }
    }

    private void initProcessingStrategy() throws InitialisationException {
        Optional processingStrategyFromRootContainer = MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.componentLocator, (Location)this.getRootContainerLocation());
        this.processingStrategy = processingStrategyFromRootContainer.orElseGet(() -> MessageProcessors.createDefaultProcessingStrategyFactory().create(this.muleContext, this.toString() + ".ps"));
        if (!processingStrategyFromRootContainer.isPresent()) {
            this.ownedProcessingStrategy = true;
            LifecycleUtils.initialiseIfNeeded((Object)this.processingStrategy);
        }
    }

    private void startInnerFlux() {
        this.fluxSupplier = RxUtils.createRoundRobinFluxSupplier(p -> {
            OperationInnerProcessor innerProcessor = new OperationInnerProcessor(){

                public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                    return Mono.subscriberContext().flatMapMany(ctx -> {
                        FluxSinkRecorder emitter = new FluxSinkRecorder();
                        return Flux.from((Publisher)RxUtils.propagateCompletion((Publisher)Flux.from((Publisher)publisher), (Publisher)emitter.flux(), pub -> Flux.from((Publisher)pub).doOnNext(this.innerEventDispatcher((Context)ctx, (FluxSinkRecorder<Either<EventProcessingException, CoreEvent>>)emitter)).map(e -> Either.empty()), () -> emitter.complete(), e -> emitter.error(e))).map(result -> (CoreEvent)result.reduce(me -> {
                            throw Exceptions.propagateWrappingFatal((Throwable)me);
                        }, response -> response));
                    });
                }

                private Consumer<? super CoreEvent> innerEventDispatcher(Context ctx, FluxSinkRecorder<Either<EventProcessingException, CoreEvent>> emitter) {
                    return event -> ComponentMessageProcessor.this.prepareAndExecuteOperation(event, () -> new CompletableComponentExecutor.ExecutorCallback((FluxSinkRecorder)emitter, (CoreEvent)event){
                        final /* synthetic */ FluxSinkRecorder val$emitter;
                        final /* synthetic */ CoreEvent val$event;
                        {
                            this.val$emitter = fluxSinkRecorder;
                            this.val$event = coreEvent;
                        }

                        public void complete(Object value) {
                            this.val$emitter.next((Object)Either.right((Object)((CoreEvent)value)));
                        }

                        public void error(Throwable e) {
                            this.val$emitter.next((Object)Either.left((Object)new EventProcessingException(this.val$event, e, false)));
                        }
                    }, ctx);
                }

                public ReactiveProcessor.ProcessingType getProcessingType() {
                    return ComponentMessageProcessor.this.getInnerProcessingType();
                }

                public boolean isAsync() {
                    return ComponentMessageProcessor.this.isAsync();
                }
            };
            return Flux.from((Publisher)this.processingStrategy.configureInternalPublisher((Publisher)Flux.from((Publisher)p).transform((Function)this.processingStrategy.onProcessor((ReactiveProcessor)innerProcessor)).doOnNext(result -> SdkInternalContext.from(result).getOperationExecutionParams(this.getLocation(), result.getContext().getId()).getCallback().complete(result)).onErrorContinue((t, result) -> {
                CoreEvent event = ((EventProcessingException)t).getEvent();
                SdkInternalContext.from(event).getOperationExecutionParams(this.getLocation(), event.getContext().getId()).getCallback().error(((EventProcessingException)t).getCause());
            })));
        }, (int)Runtime.getRuntime().availableProcessors());
    }

    private CoreEvent addContextToEvent(CoreEvent event, Context ctx) throws MuleException {
        SdkInternalContext sdkInternalContext = SdkInternalContext.from(event);
        if (sdkInternalContext == null) {
            sdkInternalContext = new SdkInternalContext();
            ((InternalEvent)event).setSdkInternalContext((EventInternalContext)sdkInternalContext);
        }
        ComponentLocation location = this.getLocation();
        String eventId = event.getContext().getId();
        sdkInternalContext.putContext(location, eventId);
        if (this.hasNestedChain && (ctx.hasKey((Object)"policy.nextOperation") || ctx.hasKey((Object)"policy.isPropagateMessageTransformations"))) {
            sdkInternalContext.setInnerChainSubscriberContextMapping(innerChainCtx -> {
                if (ctx.hasKey((Object)"policy.nextOperation")) {
                    innerChainCtx = innerChainCtx.put((Object)"policy.nextOperation", ctx.get((Object)"policy.nextOperation"));
                }
                if (ctx.hasKey((Object)"policy.isPropagateMessageTransformations")) {
                    innerChainCtx = innerChainCtx.put((Object)"policy.isPropagateMessageTransformations", ctx.get((Object)"policy.isPropagateMessageTransformations"));
                }
                return innerChainCtx;
            });
        }
        sdkInternalContext.setConfiguration(location, eventId, this.resolveConfiguration(event));
        Map<String, Object> resolutionResult = this.getResolutionResult(event, sdkInternalContext.getConfiguration(location, eventId));
        sdkInternalContext.setResolutionResult(location, eventId, resolutionResult);
        sdkInternalContext.setPolicyToApply(location, eventId, location != null ? this.policyManager.createOperationPolicy((Component)this, event, () -> resolutionResult) : DefaultPolicyManager.noPolicyOperation());
        return event;
    }

    private void prepareAndExecuteOperation(CoreEvent event, Supplier<CompletableComponentExecutor.ExecutorCallback> callbackSupplier, Context ctx) {
        ExecutionContextAdapter<T> operationContext;
        SdkInternalContext.OperationExecutionParams oep = SdkInternalContext.from(event).getOperationExecutionParams(this.getLocation(), event.getContext().getId());
        Scheduler currentScheduler = ctx.getOrEmpty((Object)"mule.nb.processorScheduler").orElse(ImmediateScheduler.IMMEDIATE_SCHEDULER);
        if (this.shouldUsePrecalculatedContext(event)) {
            operationContext = this.getPrecalculatedContext(oep.getOperationEvent());
            operationContext.setCurrentScheduler(currentScheduler);
            ((InternalEvent)operationContext.getEvent()).setSdkInternalContext(((InternalEvent)event).getSdkInternalContext());
        } else {
            operationContext = this.createExecutionContext(oep.getConfiguration(), oep.getParameters(), oep.getOperationEvent(), currentScheduler);
        }
        this.executeOperation(operationContext, this.mapped(callbackSupplier.get(), operationContext));
    }

    private void initRetryPolicyResolver() {
        Optional<ConfigurationInstance> staticConfig = this.getStaticConfiguration();
        if (staticConfig.isPresent() || !this.requiresConfig()) {
            RetryPolicyTemplate staticPolicy = this.fetchRetryPolicyTemplate(staticConfig);
            this.retryPolicyResolver = config -> staticPolicy;
        } else {
            this.retryPolicyResolver = this::fetchRetryPolicyTemplate;
        }
    }

    private RetryPolicyTemplate getRetryPolicyTemplate(Optional<ConfigurationInstance> configuration) {
        return this.retryPolicyResolver.apply(configuration);
    }

    private RetryPolicyTemplate fetchRetryPolicyTemplate(Optional<ConfigurationInstance> configuration) {
        RetryPolicyTemplate delegate = null;
        if (this.retryPolicyTemplate != null) {
            delegate = configuration.map(config -> config.getConnectionProvider().orElse(null)).map(provider -> this.connectionManager.getReconnectionConfigFor(provider).getRetryPolicyTemplate(this.retryPolicyTemplate)).orElse(this.retryPolicyTemplate);
        }
        if (delegate == null) {
            delegate = configuration.map(config -> config.getConnectionProvider().orElse(null)).map(provider -> this.connectionManager.getRetryTemplateFor(provider)).orElse(this.fallbackRetryPolicyTemplate);
        }
        return delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableComponentExecutor<T> createComponentExecutor() throws InitialisationException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LazyValue resolvingContext = new LazyValue(() -> {
            CoreEvent initialiserEvent = null;
            try {
                initialiserEvent = NullEventFactory.getNullEvent();
                ValueResolvingContext valueResolvingContext = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).withConfig(this.getStaticConfiguration()).build();
                return valueResolvingContext;
            }
            finally {
                if (initialiserEvent != null) {
                    ((BaseEventContext)initialiserEvent.getContext()).success();
                }
            }
        });
        LazyValue dynamicConfig = new LazyValue(() -> this.extensionManager.getConfigurationProvider(this.extensionModel, this.componentModel, ((ValueResolvingContext)resolvingContext.get()).getEvent()).map(ConfigurationProvider::isDynamic).orElse(false));
        try {
            for (ParameterGroupModel group : this.componentModel.getParameterGroupModels()) {
                List<ParameterModel> fieldParameters;
                if (group.getName().equals("General")) {
                    for (ParameterModel p : group.getParameterModels()) {
                        ValueResolver<?> resolver;
                        if (!p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent() || (resolver = this.resolverSet.getResolvers().get(p.getName())) == null) continue;
                        params.put(IntrospectionUtils.getMemberName(p), this.resolveComponentExecutorParam((LazyValue<ValueResolvingContext>)resolvingContext, (LazyValue<Boolean>)dynamicConfig, p, resolver));
                    }
                    continue;
                }
                ParameterGroupDescriptor groupDescriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(g -> g.getDescriptor()).orElse(null);
                if (groupDescriptor == null || (fieldParameters = this.getGroupsOfFieldParameters(group)).isEmpty()) continue;
                ObjectBuilder groupBuilder = this.createFieldParameterGroupBuilder(groupDescriptor, fieldParameters);
                try {
                    params.put(((Field)groupDescriptor.getContainer()).getName(), groupBuilder.build((ValueResolvingContext)resolvingContext.get()));
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
            CompletableComponentExecutor completableComponentExecutor = MuleExtensionUtils.getOperationExecutorFactory(this.componentModel).createExecutor(this.componentModel, params);
            return completableComponentExecutor;
        }
        finally {
            resolvingContext.ifComputed(ValueResolvingContext::close);
        }
    }

    private Object resolveComponentExecutorParam(LazyValue<ValueResolvingContext> resolvingContext, LazyValue<Boolean> dynamicConfig, ParameterModel p, ValueResolver<?> resolver) throws InitialisationException {
        try {
            Object resolvedValue;
            if (resolver instanceof ConfigOverrideValueResolverWrapper) {
                resolvedValue = ((ConfigOverrideValueResolverWrapper)resolver).resolveWithoutConfig((ValueResolvingContext)resolvingContext.get());
                if (resolvedValue == null) {
                    if (((Boolean)dynamicConfig.get()).booleanValue()) {
                        ComponentLocation location = this.getLocation();
                        String message = String.format("Component '%s' at %s uses a dynamic configuration and defines configuration override parameter '%s' which is assigned on initialization. That combination is not supported. Please use a non dynamic configuration or don't set the parameter.", location != null ? location.getComponentIdentifier().getIdentifier().toString() : this.toString(), this.toString(), p.getName());
                        throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)message), (Initialisable)this);
                    }
                    resolvedValue = resolver.resolve((ValueResolvingContext)resolvingContext.get());
                }
            } else {
                resolvedValue = ResolverUtils.resolveValue(resolver, (ValueResolvingContext)resolvingContext.get());
            }
            return resolvedValue;
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ObjectBuilder createFieldParameterGroupBuilder(ParameterGroupDescriptor groupDescriptor, List<ParameterModel> fieldParameters) {
        DefaultObjectBuilder groupBuilder = new DefaultObjectBuilder(groupDescriptor.getType().getDeclaringClass().get(), this.reflectionCache);
        fieldParameters.forEach(p -> {
            ValueResolver<?> resolver = this.resolverSet.getResolvers().get(p.getName());
            if (resolver != null) {
                Optional<Field> memberField = IntrospectionUtils.getMemberField((EnrichableModel)p);
                if (memberField.isPresent()) {
                    groupBuilder.addPropertyResolver(IntrospectionUtils.getMemberField((EnrichableModel)p).get(), resolver);
                } else {
                    groupBuilder.addPropertyResolver(p.getName(), resolver);
                }
            }
        });
        return groupBuilder;
    }

    private List<ParameterModel> getGroupsOfFieldParameters(ParameterGroupModel group) {
        return group.getParameterModels().stream().filter(p -> p.getModelProperty(FieldOperationParameterModelProperty.class).isPresent()).collect(Collectors.toList());
    }

    protected ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid(this.componentModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? this.getValueReturnDelegate() : this.getTargetReturnDelegate();
    }

    protected ReturnDelegate getTargetReturnDelegate() {
        if (ExpressionLanguageUtils.isSanitizedPayload((String)ExpressionLanguageUtils.sanitize((String)this.targetValue))) {
            return new PayloadTargetReturnDelegate(this.target, this.componentModel, this.cursorProviderFactory, this.muleContext);
        }
        return new TargetReturnDelegate(this.target, this.targetValue, this.componentModel, this.expressionManager, this.cursorProviderFactory, this.muleContext);
    }

    protected ValueReturnDelegate getValueReturnDelegate() {
        return new ValueReturnDelegate(this.componentModel, this.cursorProviderFactory, this.muleContext);
    }

    protected boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "an expression", "target"));
        }
        if (!this.muleContext.getExpressionManager().isExpression(this.targetValue)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.getLocation().getRootContainerName(), this.componentModel.getName(), "something that is not an expression", "targetValue"));
        }
        return true;
    }

    protected boolean isAsync() {
        if (!this.requiresConfig()) {
            return false;
        }
        if (this.usesDynamicConfiguration()) {
            return true;
        }
        Optional<ConfigurationInstance> staticConfig = this.getStaticConfiguration();
        if (staticConfig.isPresent()) {
            return this.getRetryPolicyTemplate(staticConfig).isEnabled();
        }
        return true;
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.componentExecutor);
        if (this.ownedProcessingStrategy) {
            LifecycleUtils.startIfNeeded((Object)this.processingStrategy);
        }
        if (this.outerFluxTerminationTimeout >= 0L) {
            this.outerFluxCompletionScheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withMaxConcurrentTasks(1).withName(this.toString() + ".outer.flux."));
        }
        this.startInnerFlux();
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.componentExecutor);
        this.stopInnerFlux();
        if (this.ownedProcessingStrategy) {
            LifecycleUtils.stopIfNeeded((Object)this.processingStrategy);
        }
        if (this.outerFluxTerminationTimeout >= 0L && this.outerFluxCompletionScheduler != null) {
            this.outerFluxCompletionScheduler.stop();
            this.outerFluxCompletionScheduler = null;
        }
    }

    private void outerPublisherSubscribedTo() {
        this.activeOuterPublishersCount.getAndIncrement();
    }

    private void outerPublisherTerminated() {
        if (this.activeOuterPublishersCount.decrementAndGet() == 0) {
            this.stopInnerFlux();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInnerFlux() {
        if (this.fluxSupplier != null) {
            Object object = this.fluxSupplierDisposeLock;
            synchronized (object) {
                if (this.fluxSupplier != null) {
                    this.fluxSupplier.dispose();
                    this.fluxSupplier = null;
                }
            }
        }
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.componentExecutor, (Logger)LOGGER);
        if (this.ownedProcessingStrategy) {
            LifecycleUtils.disposeIfNeeded((Object)this.processingStrategy, (Logger)LOGGER);
        }
        this.initialised = false;
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator<ComponentModel>(this.extensionModel, this.componentModel, this.createInterceptorChain(), this.errorTypeRepository, this.resultTransformer);
    }

    protected InterceptorChain createInterceptorChain() {
        InterceptorChain.Builder chainBuilder = InterceptorChain.builder();
        if (this.componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)this.componentModel).requiresConnection()) {
            this.addConnectionInterceptors(chainBuilder);
        }
        return chainBuilder.build();
    }

    private void addConnectionInterceptors(InterceptorChain.Builder chainBuilder) {
        chainBuilder.addInterceptor(new ConnectionInterceptor(this.extensionConnectionSupplier));
        this.addCursorResetInterceptor(chainBuilder);
    }

    private void addCursorResetInterceptor(InterceptorChain.Builder chainBuilder) {
        ArrayList<String> streamParams = new ArrayList<String>(5);
        this.componentModel.getAllParameterModels().forEach(p -> ExtensionMetadataTypeUtils.getType((MetadataType)p.getType(), (ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel)).filter(clazz -> InputStream.class.isAssignableFrom((Class<?>)clazz) || Iterator.class.isAssignableFrom((Class<?>)clazz)).ifPresent(clazz -> streamParams.add(p.getName())));
        if (!streamParams.isEmpty()) {
            chainBuilder.addInterceptor(new CursorResetInterceptor(streamParams));
        }
    }

    @Override
    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    /*
     * Loose catch block
     */
    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        CoreEvent event = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
        try {
            try (ValueResolvingContext ctx = ValueResolvingContext.builder(event, this.expressionManager).build();){
                LazyExecutionContext<ComponentModel> executionContext = new LazyExecutionContext<ComponentModel>(this.resolverSet, this.componentModel, this.extensionModel, ctx);
                OperationParameterValueResolver<ComponentModel> operationParameterValueResolver = new OperationParameterValueResolver<ComponentModel>(executionContext, this.resolverSet, this.reflectionCache, this.expressionManager);
                return operationParameterValueResolver;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (event != null) {
                ((BaseEventContext)event.getContext()).success();
            }
        }
    }

    public ReactiveProcessor.ProcessingType getInnerProcessingType() {
        return ReactiveProcessor.ProcessingType.CPU_LITE;
    }

    public void resolveParameters(CoreEvent.Builder eventBuilder, BiConsumer<Map<String, Supplier<Object>>, ExecutionContext> afterConfigurer) throws MuleException {
        if (this.componentExecutor instanceof OperationArgumentResolverFactory) {
            DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
            ExecutionContextAdapter<T> delegateExecutionContext = this.createExecutionContext(eventBuilder.build());
            PrecalculatedExecutionContextAdapter<T> executionContext = new PrecalculatedExecutionContextAdapter<T>(delegateExecutionContext);
            Throwable throwable = mediator.applyBeforeInterceptors(executionContext);
            if (throwable == null) {
                Map<String, Object> resolvedArguments = ((OperationArgumentResolverFactory)this.componentExecutor).createArgumentResolver(this.componentModel).apply(executionContext);
                afterConfigurer.accept(resolvedArguments, executionContext);
                executionContext.changeEvent(eventBuilder.build());
            } else {
                throw new DefaultMuleException("Interception execution for operation not ok", throwable);
            }
        }
    }

    public void disposeResolvedParameters(ExecutionContext<T> executionContext) {
        ((DefaultExecutionMediator)this.executionMediator).applyAfterInterceptors(executionContext);
    }

    private ExecutionContextAdapter<T> createExecutionContext(CoreEvent event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event, ImmediateScheduler.IMMEDIATE_SCHEDULER);
    }

    private Map<String, Object> getResolutionResult(CoreEvent event, Optional<ConfigurationInstance> configuration) throws MuleException {
        try (ValueResolvingContext context = ValueResolvingContext.builder(event, this.expressionManager).withConfig(configuration).build();){
            Map<String, Object> map = this.resolverSet.resolve(context).asMap();
            return map;
        }
    }

    private boolean isInterceptedComponent(ComponentLocation location, InternalEvent event) {
        Component component = (Component)event.getInternalParameter("core:interceptionComponent");
        if (component != null) {
            return location.equals(component.getLocation());
        }
        return false;
    }

    private boolean supportsTransactions(T componentModel) {
        return componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)componentModel).isTransactional();
    }

    private boolean hasNestedChain(T componentModel) {
        return componentModel.getNestedComponents().stream().anyMatch(nestedComp -> nestedComp instanceof NestedRouteModel || ((NestedComponentModel)nestedComp).getAllowedStereotypes().stream().anyMatch(st -> st.isAssignableTo(MuleStereotypes.PROCESSOR)));
    }

    private Optional<TransactionConfig> buildTransactionConfig() throws MuleException {
        if (this.supportsTransactions(this.componentModel)) {
            MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
            transactionConfig.setAction(MuleExtensionUtils.toActionCode(this.getTransactionalAction()));
            transactionConfig.setMuleContext(this.muleContext);
            transactionConfig.setFactory((TransactionFactory)TRANSACTION_FACTORY);
            return Optional.of(transactionConfig);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationTransactionalAction getTransactionalAction() throws MuleException {
        ValueResolver<?> resolver = this.resolverSet.getResolvers().get("transactionalAction");
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Operation '%s' from extension '%s' is transactional but no transactional action defined", this.componentModel.getName(), this.extensionModel.getName()));
        }
        CoreEvent initializerEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
        try {
            OperationTransactionalAction operationTransactionalAction = (OperationTransactionalAction)resolver.resolve(ValueResolvingContext.builder(initializerEvent).build());
            return operationTransactionalAction;
        }
        finally {
            ((BaseEventContext)initializerEvent.getContext()).success();
        }
    }

    public String toString() {
        ComponentLocation location = this.getLocation();
        return location != null ? location.getLocation() : super.toString();
    }
}

