/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.error.ErrorTypeRepositoryProvider;
import org.mule.runtime.ast.internal.error.DefaultErrorTypeRepository;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.internal.exception.SuppressedMuleException;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.exception.TestError;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class ModuleExceptionHandlerTestCase
extends AbstractMuleTestCase {
    private static final String SPECIFIED_ERROR_MESSAGE = "This is the module exception message";
    private static final String SPECIFIED_CAUSE_ERROR_MESSAGE = "This is the cause message";
    private static final String ERROR_NAMESPACE = "TEST-EXTENSION";
    private OperationModel operationModel;
    private ExtensionModel extensionModel;
    private CoreEvent event;
    private final ErrorTypeRepository typeRepository = new DefaultErrorTypeRepository();
    @Parameterized.Parameter
    public boolean suppressErrors;

    @Parameterized.Parameters(name="Suppress errors: {0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @Before
    public void setUp() {
        this.operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        this.extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        this.event = (CoreEvent)Mockito.mock(CoreEvent.class);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"Test Extension");
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"testOperation");
    }

    @Test
    public void handleThrowingOfNotDeclaredErrorType() {
        this.typeRepository.addErrorType(ComponentIdentifier.buildFromStringRepresentation((String)"TEST-EXTENSION:CONNECTIVITY"), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.processException((Throwable)moduleException)).isInstanceOf(MuleRuntimeException.class)).hasMessage("The component 'testOperation' from the connector 'Test Extension' attempted to throw 'TEST-EXTENSION:CONNECTIVITY', but only [TEST-EXTENSION:TRANSFORMATION] errors are allowed.");
    }

    @Test
    public void handleThrowingChildErrorsFromTheOneDeclared() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        ErrorModel parent = ErrorModelBuilder.newError((String)TestError.PARENT.getType(), (String)ERROR_NAMESPACE).build();
        ErrorModel child = ErrorModelBuilder.newError((String)TestError.CHILD.getType(), (String)ERROR_NAMESPACE).withParent(parent).build();
        errors.add(parent);
        ErrorType parentErrorType = this.typeRepository.addErrorType(this.getIdentifier(parent), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        this.typeRepository.addErrorType(this.getIdentifier(child), parentErrorType);
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(errors);
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)TestError.CHILD, (Throwable)new RuntimeException());
        Throwable throwable = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        ErrorType errorType = ((TypedException)throwable).getErrorType();
        MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)TestError.CHILD.getType()));
        MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)CoreMatchers.is((Object)ERROR_NAMESPACE));
    }

    @Test
    public void handleThrowingOfNotRegisteredErrorType() {
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.processException((Throwable)moduleException)).isInstanceOf(MuleRuntimeException.class)).hasMessage("The component 'testOperation' from the connector 'Test Extension' attempted to throw 'TEST-EXTENSION:CONNECTIVITY', but it was not registered in the Error Repository");
    }

    @Test
    public void handleTypedException() {
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        this.typeRepository.addErrorType(ComponentIdentifier.builder().name("CONNECTIVITY").namespace(ERROR_NAMESPACE).build(), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        Throwable exception = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        ErrorType errorType = ((TypedException)exception).getErrorType();
        MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)CoreMatchers.is((Object)ERROR_NAMESPACE));
    }

    @Test
    @Issue(value="MULE-18041")
    @Story(value="Error Handling")
    public void suppressMessagingException() {
        Mockito.when((Object)this.event.getError()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)ERROR_NAMESPACE).build()));
        MessagingException messagingException = new MessagingException(I18nMessageFactory.createStaticMessage((String)"Suppressed exception"), this.event);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)messagingException);
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        this.typeRepository.addErrorType(ComponentIdentifier.builder().name("CONNECTIVITY").namespace(ERROR_NAMESPACE).build(), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        Throwable exception = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        if (this.suppressErrors) {
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SuppressedMuleException.class)));
            MatcherAssert.assertThat((Object)((SuppressedMuleException)exception.getCause()).getSuppressedException(), (Matcher)CoreMatchers.is((Object)messagingException));
        } else {
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(SuppressedMuleException.class))));
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)CoreMatchers.is((Object)messagingException));
        }
    }

    @Test
    @Issue(value="W-11192984")
    @Story(value="Error Handling")
    public void useModuleExceptionMessageWhenCauseHasNoMessage() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        ErrorModel parent = ErrorModelBuilder.newError((String)TestError.PARENT.getType(), (String)ERROR_NAMESPACE).build();
        errors.add(parent);
        this.typeRepository.addErrorType(this.getIdentifier(parent), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(errors);
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        ModuleException moduleException = new ModuleException(SPECIFIED_ERROR_MESSAGE, (ErrorTypeDefinition)TestError.PARENT, (Throwable)new SpecificRuntimeException());
        Throwable throwable = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)CoreMatchers.containsString((String)SPECIFIED_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable.getCause().getCause(), (Matcher)CoreMatchers.instanceOf(SpecificRuntimeException.class));
    }

    @Test
    @Issue(value="W-11192984")
    @Story(value="Error Handling")
    public void useCauseMessageWhenCauseHasMessage() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        ErrorModel parent = ErrorModelBuilder.newError((String)TestError.PARENT.getType(), (String)ERROR_NAMESPACE).build();
        errors.add(parent);
        this.typeRepository.addErrorType(this.getIdentifier(parent), ErrorTypeRepositoryProvider.getCoreErrorTypeRepo().getAnyErrorType());
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(errors);
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository, this.suppressErrors);
        ModuleException moduleException = new ModuleException(SPECIFIED_ERROR_MESSAGE, (ErrorTypeDefinition)TestError.PARENT, (Throwable)new SpecificRuntimeException(SPECIFIED_CAUSE_ERROR_MESSAGE));
        Throwable throwable = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)throwable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)CoreMatchers.containsString((String)SPECIFIED_CAUSE_ERROR_MESSAGE));
        MatcherAssert.assertThat((Object)throwable.getCause(), (Matcher)CoreMatchers.instanceOf(SpecificRuntimeException.class));
    }

    private ComponentIdentifier getIdentifier(ErrorModel parent) {
        return ComponentIdentifier.buildFromStringRepresentation((String)(parent.getNamespace() + ":" + parent.getType()));
    }

    public static class SpecificRuntimeException
    extends RuntimeException {
        public SpecificRuntimeException() {
        }

        public SpecificRuntimeException(String errorMessage) {
            super(errorMessage);
        }
    }
}

