/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import reactor.core.publisher.BaseSubscriber;

class ItemsConsumer<T>
extends BaseSubscriber<T> {
    private final CountDownLatch expectedItemsConsumedCountDownLatch;
    private Throwable error;

    ItemsConsumer(int numItemsExpected) {
        this.expectedItemsConsumedCountDownLatch = new CountDownLatch(numItemsExpected);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.expectedItemsConsumedCountDownLatch.await(timeout, unit);
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
        return result;
    }

    protected void hookOnSubscribe(Subscription subscription) {
        subscription.request(this.expectedItemsConsumedCountDownLatch.getCount());
    }

    protected void hookOnNext(@Nonnull T value) {
        this.expectedItemsConsumedCountDownLatch.countDown();
    }

    protected void hookOnError(@Nonnull Throwable throwable) {
        this.error = throwable;
        while (this.expectedItemsConsumedCountDownLatch.getCount() > 0L) {
            this.expectedItemsConsumedCountDownLatch.countDown();
        }
    }
}

