/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionHandler;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkMethodInvocationException;

public final class ExceptionHandlerManager {
    private static final ExceptionHandler DEFAULT_EXCEPTION_ENRICHER = new NullExceptionHandler();
    private static boolean HONOURS_EXTENSION_NAMESPACE = Boolean.getBoolean("mule.honour.extension.error.namespace");
    private final ExceptionHandler exceptionHandler;
    private final ErrorType connectionErrorType;

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel) {
        this(extensionModel, componentModel, null);
    }

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel, ErrorTypeRepository errorTypeRepository) {
        this.exceptionHandler = this.findExceptionHandler(extensionModel, (EnrichableModel)componentModel);
        this.connectionErrorType = errorTypeRepository == null ? null : this.resolveConnectionErrorType(extensionModel, errorTypeRepository);
    }

    private ErrorType resolveConnectionErrorType(ExtensionModel extensionModel, ErrorTypeRepository errorTypeRepository) {
        String extensionNamespace = extensionModel.getName() != null ? extensionModel.getName().toUpperCase() : null;
        String namespaceFromXmlDsl = extensionModel.getXmlDslModel().getPrefix().toUpperCase();
        Predicate<ErrorModel> connectivityErrorCondition = errorModel -> errorModel.getType().equals("CONNECTIVITY");
        Predicate<ErrorModel> extensionConnectivityErrorCondition = connectivityErrorCondition.and(errorModel -> errorModel.getNamespace().equals(extensionNamespace) || this.errorHasNamespaceFromDsl((ErrorModel)errorModel, namespaceFromXmlDsl));
        return extensionModel.getErrorModels().stream().filter(extensionConnectivityErrorCondition).findFirst().map(Optional::of).orElseGet(() -> extensionModel.getErrorModels().stream().filter(connectivityErrorCondition).findFirst()).map(errorModel -> errorTypeRepository.getErrorType(ComponentIdentifier.builder().namespace(errorModel.getNamespace()).name(errorModel.getType()).build()).orElse(null)).orElse(null);
    }

    private boolean errorHasNamespaceFromDsl(ErrorModel errorModel, String namespaceFromDsl) {
        return HONOURS_EXTENSION_NAMESPACE ? errorModel.getNamespace().equals(namespaceFromDsl) : false;
    }

    public Throwable process(Throwable t) {
        Throwable handled = this.handleThrowable(t);
        Throwable result = this.enrich(handled);
        return result != null ? result : handled;
    }

    public Throwable handleThrowable(Throwable e) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)e);
        if (connectionException.isPresent()) {
            return this.resolveConnectionException((ConnectionException)connectionException.get());
        }
        return e instanceof SdkMethodInvocationException ? e.getCause() : e;
    }

    private Throwable resolveConnectionException(ConnectionException connectionException) {
        if (this.connectionErrorType != null && !connectionException.getErrorType().isPresent()) {
            ConnectionException newException = new ConnectionException(connectionException.getMessage(), connectionException.getCause(), this.connectionErrorType, connectionException.getConnection().orElse(null));
            newException.getInfo().putAll(connectionException.getInfo());
            return newException;
        }
        return connectionException;
    }

    private Throwable enrich(Throwable t) {
        return t instanceof Exception ? this.exceptionHandler.enrichException((Exception)t) : t;
    }

    private ExceptionHandler findExceptionHandler(ExtensionModel extension, EnrichableModel child) {
        return this.findExceptionHandler(child).orElseGet(() -> this.findExceptionHandler((EnrichableModel)extension).orElse(DEFAULT_EXCEPTION_ENRICHER));
    }

    private Optional<ExceptionHandler> findExceptionHandler(EnrichableModel model) {
        return model.getModelProperty(ExceptionHandlerModelProperty.class).map(p -> p.getExceptionHandlerFactory().createHandler());
    }

    ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    static void resetProperties() {
        HONOURS_EXTENSION_NAMESPACE = Boolean.getBoolean("mule.honour.extension.error.namespace");
    }
}

