/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.PrivilegedApiValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PrivilegedApiValidatorTestCase
extends AbstractMuleTestCase {
    private static final String EXTENSION_NAME = "my extension";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExtensionModel extensionModel;
    private PrivilegedApiValidator validator = new PrivilegedApiValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)EXTENSION_NAME);
    }

    @Test
    public void valid() {
        Mockito.when((Object)this.extensionModel.getPrivilegedArtifacts()).thenReturn(Collections.singleton("org.mule.test:foo"));
        Mockito.when((Object)this.extensionModel.getPrivilegedPackages()).thenReturn(Collections.singleton("org.foo"));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void noPrivilegedExportedPackages() {
        Mockito.when((Object)this.extensionModel.getPrivilegedPackages()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getPrivilegedArtifacts()).thenReturn(Collections.singleton("org.mule.test:foo"));
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Extension has privileged artifacts but no privileged packages defined"));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void noPrivilegedArtifacts() {
        Mockito.when((Object)this.extensionModel.getPrivilegedPackages()).thenReturn(Collections.singleton("org.foo"));
        Mockito.when((Object)this.extensionModel.getPrivilegedArtifacts()).thenReturn(Collections.emptySet());
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"Extension has privileged packages but no privileged artifacts defined"));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void noPrivilegedApi() throws Exception {
        Mockito.when((Object)this.extensionModel.getPrivilegedPackages()).thenReturn(Collections.emptySet());
        Mockito.when((Object)this.extensionModel.getPrivilegedArtifacts()).thenReturn(Collections.emptySet());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

