/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.UpdatingAuthorizationCodeState;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.exception.TokenInvalidatedException;
import org.mule.runtime.oauth.api.AuthorizationCodeOAuthDancer;
import org.mule.runtime.oauth.api.listener.AuthorizationCodeListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class UpdatingAuthorizationCodeStateTestCase
extends AbstractMuleTestCase {
    private static final String ACCESS_TOKEN = "myToken";
    private static final String REFRESH_TOKEN = "myRefreshToken";
    private static final String NEW_TOKEN = "newToken";
    private static final String NEW_REFRESH_TOKEN = "newRefresh";
    private static final String RESOURCE_OWNER_ID = "id";
    private AuthorizationCodeConfig oAuthConfig;
    @Mock
    private AuthorizationCodeOAuthDancer dancer;
    @Mock
    private ResourceOwnerOAuthContext initialContext;
    @Mock
    private ResourceOwnerOAuthContext refreshedContext;

    @Before
    public void before() {
        this.oAuthConfig = new AuthorizationCodeConfig("configName", Optional.empty(), MultiMap.emptyMultiMap(), MultiMap.emptyMultiMap(), Collections.emptyMap(), new AuthorizationCodeGrantType("url", "url", "#[s]", "reg", "#[x]", "sd"), (OAuthCallbackConfig)Mockito.mock(OAuthCallbackConfig.class), "key", "secret", "url", "url", "scope", RESOURCE_OWNER_ID, null, null);
        Mockito.when((Object)this.initialContext.getAccessToken()).thenReturn((Object)ACCESS_TOKEN);
        Mockito.when((Object)this.initialContext.getRefreshToken()).thenReturn((Object)REFRESH_TOKEN);
        Mockito.when((Object)this.initialContext.getResourceOwnerId()).thenReturn((Object)RESOURCE_OWNER_ID);
        Mockito.when((Object)this.refreshedContext.getAccessToken()).thenReturn((Object)NEW_TOKEN);
        Mockito.when((Object)this.refreshedContext.getRefreshToken()).thenReturn((Object)NEW_REFRESH_TOKEN);
        Mockito.when((Object)this.refreshedContext.getResourceOwnerId()).thenReturn((Object)RESOURCE_OWNER_ID);
    }

    @Test
    public void onRefreshToken() {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), false);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        this.assertTokenRefreshed((Reference<ResourceOwnerOAuthContext>)newContext, state, listener);
    }

    @Test
    public void onTokenInvalidated() {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), false);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        listener.onTokenInvalidated();
        try {
            state.getAccessToken();
            Assert.fail((String)"This should have failed");
        }
        catch (TokenInvalidatedException tokenInvalidatedException) {
            // empty catch block
        }
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        Assert.assertThat((Object)newContext.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void onTokenUpdatedAfterInvalidation() {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), false);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        listener.onTokenInvalidated();
        try {
            state.getAccessToken();
            Assert.fail((String)"This should have failed");
        }
        catch (TokenInvalidatedException tokenInvalidatedException) {
            // empty catch block
        }
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        this.assertTokenRefreshed((Reference<ResourceOwnerOAuthContext>)newContext, state, listener);
    }

    @Test
    public void onReAuthorization() {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), false);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        AuthorizationCodeListener listener = (AuthorizationCodeListener)listenerCaptor.getValue();
        listener.onAuthorizationCompleted(this.refreshedContext);
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)NEW_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)NEW_REFRESH_TOKEN));
        Assert.assertThat((Object)newContext.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.refreshedContext)));
    }

    private void assertTokenRefreshed(Reference<ResourceOwnerOAuthContext> newContext, UpdatingAuthorizationCodeState state, AuthorizationCodeListener listener) {
        listener.onTokenRefreshed(this.refreshedContext);
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)NEW_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)NEW_REFRESH_TOKEN));
        Assert.assertThat((Object)newContext.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.refreshedContext)));
    }

    @Test
    @Issue(value="W-15154658")
    public void accessTokenVisitsTokensStoreIfClusterIsEnabled() throws Exception {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), true);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer, (VerificationMode)Mockito.times((int)1))).getInvalidateFromTokensStore((String)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="W-15154658")
    public void accessTokenVisitsTokensStoreWithoutCluster() throws Exception {
        ArgumentCaptor listenerCaptor = ArgumentCaptor.forClass(AuthorizationCodeListener.class);
        Reference newContext = new Reference();
        UpdatingAuthorizationCodeState state = new UpdatingAuthorizationCodeState(this.oAuthConfig, this.dancer, this.initialContext, arg_0 -> ((Reference)newContext).set(arg_0), false);
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer)).addListener(ArgumentMatchers.anyString(), (AuthorizationCodeListener)listenerCaptor.capture());
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)ACCESS_TOKEN));
        Assert.assertThat(state.getRefreshToken().get(), (Matcher)CoreMatchers.equalTo((Object)REFRESH_TOKEN));
        ((AuthorizationCodeOAuthDancer)Mockito.verify((Object)this.dancer, (VerificationMode)Mockito.never())).getInvalidateFromTokensStore((String)ArgumentMatchers.any());
    }
}

