/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.enricher.TargetParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

public class TargetParameterDeclarationEnricherTestCase {
    private ExtensionDeclaration declaration = null;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = new DefaultJavaModelLoaderDelegate(HeisenbergExtension.class, MuleManifest.getProductVersion()).declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new TargetParameterDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifyTargetParameterOnOperation() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "transform");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)EnricherTestUtils.getNamedObject(operationDeclaration.getAllParameters(), "target");
        MatcherAssert.assertThat((Object)parameterDeclaration.getName(), (Matcher)Matchers.is((Object)"target"));
        MatcherAssert.assertThat((Object)parameterDeclaration.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.NOT_SUPPORTED));
        MatcherAssert.assertThat((Object)parameterDeclaration.getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)parameterDeclaration.isRequired(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void verifyTargetValueParameterOnOperation() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getNamedObject(this.declaration.getOperations(), "transform");
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)EnricherTestUtils.getNamedObject(operationDeclaration.getAllParameters(), "targetValue");
        MatcherAssert.assertThat((Object)parameterDeclaration.getName(), (Matcher)Matchers.is((Object)"targetValue"));
        MatcherAssert.assertThat((Object)parameterDeclaration.getExpressionSupport(), (Matcher)Matchers.is((Object)ExpressionSupport.REQUIRED));
        MatcherAssert.assertThat((Object)parameterDeclaration.getType(), (Matcher)Matchers.instanceOf(StringType.class));
        MatcherAssert.assertThat((Object)parameterDeclaration.isRequired(), (Matcher)Matchers.is((Object)false));
    }
}

