/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.module.extension.internal.loader.java.AbstractJavaExtensionDeclarationTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.vegan.extension.VeganExtension;

@SmallTest
public class ComplexExtensionLoadingTestCase
extends AbstractJavaExtensionDeclarationTestCase {
    private ExtensionDeclaration extensionDeclaration;

    @Before
    public void setUp() {
        this.setLoader(this.loaderFor(VeganExtension.class));
        this.extensionDeclaration = (ExtensionDeclaration)this.declareExtension().getDeclaration();
    }

    @Test
    public void extension() {
        Assert.assertThat((Object)this.extensionDeclaration.getName(), (Matcher)CoreMatchers.is((Object)"vegan"));
        Assert.assertThat((Object)this.extensionDeclaration.getConfigurations(), (Matcher)Matchers.hasSize((int)6));
        this.assertOperation("apple-config", "eatApple");
        this.assertOperation("banana-config", "eatBanana");
        this.assertOperation("kiwi-config", "eatKiwi");
    }

    private void assertOperation(String configName, String operationName) {
        ConfigurationDeclaration config = this.extensionDeclaration.getConfigurations().stream().filter(c -> c.getName().equals(configName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No config with name " + configName));
        OperationDeclaration operation = config.getOperations().stream().filter(model -> model.getName().equals(operationName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No operation with name " + operationName));
        Assert.assertThat((Object)operation.getName(), (Matcher)CoreMatchers.is((Object)operationName));
    }
}

