/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.api.metadata.MultilevelMetadataKeyBuilder;
import org.mule.runtime.module.extension.internal.loader.java.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.metadata.MetadataKeyIdObjectResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.metadata.extension.LocationKey;

public class MetadataKeyIdObjectResolverTestCase
extends AbstractMuleTestCase {
    private static final String CITY = "city";
    private static final String SFO = "SFO";
    private static final String NY = "NY";
    private static final String COUNTRY = "country";
    private static final String USA = "USA";
    private static final String CONTINENT = "continent";
    private static final String AMERICA = "AMERICA";
    private static final MetadataKey MULTILEVEL_KEY = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild(MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"SFO", (String)"city"))).build();
    private static final MetadataKey INCOMPLETE_MULTILEVEL_KEY = MultilevelMetadataKeyBuilder.newKey((String)"AMERICA", (String)"continent").withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)"USA", (String)"country")).build();
    private static final String OPERATION_NAME = "SomeOperation";
    private static final String EMPTY = "";
    private MetadataKeyIdObjectResolver keyIdObjectResolver;
    @Mock
    public ComponentModel componentModel;
    @Mock
    public ParameterModel continentParam;
    @Mock
    public ParameterModel countryParam;
    @Mock
    public ParameterModel cityParam;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.continentParam.getName()).thenReturn((Object)CONTINENT);
        Mockito.when((Object)this.countryParam.getName()).thenReturn((Object)COUNTRY);
        Mockito.when((Object)this.cityParam.getName()).thenReturn((Object)CITY);
        Mockito.when((Object)this.continentParam.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.countryParam.isRequired()).thenReturn((Object)true);
        Mockito.when((Object)this.cityParam.isRequired()).thenReturn((Object)true);
        this.mockMetadataKeyModelProp(this.continentParam, 1);
        this.mockMetadataKeyModelProp(this.countryParam, 2);
        this.mockMetadataKeyModelProp(this.cityParam, 3);
        ReflectionCache reflectionCache = new ReflectionCache();
        this.mockDeclaringMemberModelProp(this.continentParam, CONTINENT, reflectionCache);
        this.mockDeclaringMemberModelProp(this.countryParam, COUNTRY, reflectionCache);
        this.mockDeclaringMemberModelProp(this.cityParam, CITY, reflectionCache);
        this.mockQueryModelProp(this.continentParam);
        this.mockQueryModelProp(this.countryParam);
        this.mockQueryModelProp(this.cityParam);
        Mockito.when((Object)this.componentModel.getName()).thenReturn((Object)OPERATION_NAME);
    }

    private void mockMetadataKeyModelProp(ParameterModel param, int pos) {
        Mockito.when((Object)param.getModelProperty(MetadataKeyPartModelProperty.class)).thenReturn(Optional.of(new MetadataKeyPartModelProperty(pos)));
    }

    private void mockDeclaringMemberModelProp(ParameterModel param, String name, ReflectionCache reflectionCache) {
        Field f = (Field)IntrospectionUtils.getField(LocationKey.class, (String)name, (ReflectionCache)reflectionCache).get();
        Mockito.when((Object)param.getModelProperty(DeclaringMemberModelProperty.class)).thenReturn(Optional.of(new DeclaringMemberModelProperty(f)));
    }

    private void mockQueryModelProp(ParameterModel param) {
        Mockito.when((Object)param.getModelProperty(QueryParameterModelProperty.class)).thenReturn(Optional.empty());
    }

    @Test
    public void resolveSingleLevelKey() throws MetadataResolvingException {
        this.setParameters(this.continentParam);
        this.setMetadataKeyIdModelProperty(String.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve(MultilevelMetadataKeyBuilder.newKey((String)AMERICA, (String)CONTINENT).build());
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        String stringKey = (String)key;
        MatcherAssert.assertThat((Object)stringKey, (Matcher)Matchers.is((Object)AMERICA));
    }

    @Test
    public void resolveMultiLevelKey() throws MetadataResolvingException {
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve(MULTILEVEL_KEY);
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(LocationKey.class)));
        LocationKey locationKey = (LocationKey)key;
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CONTINENT, (Matcher)Matchers.is((Object)AMERICA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)COUNTRY, (Matcher)Matchers.is((Object)USA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CITY, (Matcher)Matchers.is((Object)SFO)));
    }

    @Test
    public void resolveDefaultMultiLevelKey() throws MetadataResolvingException {
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        Mockito.when((Object)this.continentParam.getDefaultValue()).thenReturn((Object)AMERICA);
        Mockito.when((Object)this.countryParam.getDefaultValue()).thenReturn((Object)USA);
        Mockito.when((Object)this.cityParam.getDefaultValue()).thenReturn((Object)SFO);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve();
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(LocationKey.class)));
        LocationKey locationKey = (LocationKey)key;
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CONTINENT, (Matcher)Matchers.is((Object)AMERICA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)COUNTRY, (Matcher)Matchers.is((Object)USA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CITY, (Matcher)Matchers.is((Object)SFO)));
    }

    @Test
    public void resolveDefaultSingleKey() throws MetadataResolvingException {
        this.setParameters(this.continentParam);
        this.setMetadataKeyIdModelProperty(String.class);
        Mockito.when((Object)this.continentParam.getDefaultValue()).thenReturn((Object)AMERICA);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve();
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Object)AMERICA));
    }

    @Test
    public void resolveNoKeyParam() throws MetadataResolvingException {
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve();
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Object)EMPTY));
    }

    @Test
    public void resolveDsql() throws MetadataResolvingException {
        ParameterModel queryParam = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)queryParam.getModelProperty(QueryParameterModelProperty.class)).thenReturn(Optional.of(new QueryParameterModelProperty(QueryTranslator.class)));
        this.mockMetadataKeyModelProp(queryParam, 1);
        this.setParameters(queryParam);
        this.setMetadataKeyIdModelProperty(String.class);
        MetadataKey dsqlKey = MultilevelMetadataKeyBuilder.newKey((String)"dsql:SELECT id FROM Circle WHERE (diameter < 18)").build();
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object resolvedKey = this.keyIdObjectResolver.resolve(dsqlKey);
        MatcherAssert.assertThat((Object)resolvedKey, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DsqlQuery.class)));
        DsqlQuery query = (DsqlQuery)resolvedKey;
        MatcherAssert.assertThat((Object)query.getFields(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)query.getType().getName(), (Matcher)Matchers.is((Object)"Circle"));
    }

    @Test
    public void failToResolveWithNotInstantiableKey() throws MetadataResolvingException {
        this.exception.expect(MetadataResolvingException.class);
        this.exception.expectMessage(Matchers.is((Object)"MetadataKey object of type 'NotInstantiableClass' from the component 'SomeOperation' could not be instantiated"));
        this.exception.expectCause(Matchers.is((Matcher)Matchers.instanceOf(IllegalArgumentException.class)));
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(NotInstantiableClass.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        this.keyIdObjectResolver.resolve(MULTILEVEL_KEY);
    }

    @Test
    public void failToResolveWithMissingLevels() throws MetadataResolvingException {
        this.exception.expect(MetadataResolvingException.class);
        this.exception.expectMessage(Matchers.is((Object)"The given MetadataKey does not provide all the required levels. Missing levels: [city]"));
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        this.keyIdObjectResolver.resolve(INCOMPLETE_MULTILEVEL_KEY);
    }

    @Test
    public void failToResolveWithOutMetadataKeyId() throws MetadataResolvingException {
        this.exception.expect(MetadataResolvingException.class);
        this.exception.expectMessage(Matchers.is((Object)"Component 'SomeOperation' doesn't have a MetadataKeyId parameter associated"));
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        Mockito.when((Object)this.componentModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        this.keyIdObjectResolver.resolve(MULTILEVEL_KEY);
    }

    @Test
    public void failToResolveWithNoDefaultValues() throws MetadataResolvingException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage(Matchers.containsString((String)"does not have a default value for all it's components."));
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        Mockito.when((Object)this.continentParam.getDefaultValue()).thenReturn((Object)AMERICA);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        this.keyIdObjectResolver.resolve();
    }

    @Test
    public void failToResolveWithMultipleChildren() throws MetadataResolvingException {
        this.exception.expect(MetadataResolvingException.class);
        this.exception.expectMessage("MetadataKey used for Metadata resolution must only have one child per level.");
        MetadataKey invalidMetadataKey = MultilevelMetadataKeyBuilder.newKey((String)AMERICA, (String)CONTINENT).withChild(MultilevelMetadataKeyBuilder.newKey((String)USA, (String)COUNTRY).withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)SFO, (String)CITY)).withChild((MetadataKeyBuilder)MultilevelMetadataKeyBuilder.newKey((String)NY, (String)CITY))).build();
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        this.keyIdObjectResolver.resolve(invalidMetadataKey);
    }

    @Test
    public void resolveGroupWithMissingOptionalParameters() throws MetadataResolvingException {
        Mockito.when((Object)this.cityParam.isRequired()).thenReturn((Object)false);
        this.setParameters(this.continentParam, this.countryParam, this.cityParam);
        this.setMetadataKeyIdModelProperty(LocationKey.class);
        this.keyIdObjectResolver = new MetadataKeyIdObjectResolver(this.componentModel);
        Object key = this.keyIdObjectResolver.resolve(INCOMPLETE_MULTILEVEL_KEY);
        MatcherAssert.assertThat((Object)key, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(LocationKey.class)));
        LocationKey locationKey = (LocationKey)key;
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CONTINENT, (Matcher)Matchers.is((Object)AMERICA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)COUNTRY, (Matcher)Matchers.is((Object)USA)));
        MatcherAssert.assertThat((Object)locationKey, (Matcher)Matchers.hasProperty((String)CITY, (Matcher)Matchers.is((Matcher)Matchers.nullValue())));
    }

    public void setParameters(ParameterModel ... parameterModels) {
        Mockito.when((Object)this.componentModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModels));
    }

    private void setMetadataKeyIdModelProperty(Class<?> type) {
        Mockito.when((Object)this.componentModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(new MetadataKeyIdModelProperty(new JavaTypeLoader(((Object)((Object)this)).getClass().getClassLoader()).load(type), EMPTY)));
    }

    private class NotInstantiableClass {
        private NotInstantiableClass() {
        }
    }
}

