/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.DefaultExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaConfigurationDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigTypeModelProperty;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

public class JavaConfigurationDeclarationEnricherTestCase {
    private static final String GET_ENEMY = "getEnemy";
    private static final String LISTEN_PAYMENTS = "ListenPayments";
    private ExtensionDeclaration declaration = null;

    @Before
    public void setUp() {
        ExtensionDeclarer declarer = new DefaultJavaModelLoaderDelegate(HeisenbergExtension.class, MuleManifest.getProductVersion()).declare((ExtensionLoadingContext)new DefaultExtensionLoadingContext(this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        new JavaConfigurationDeclarationEnricher().enrich((ExtensionLoadingContext)new DefaultExtensionLoadingContext(declarer, this.getClass().getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet())));
        this.declaration = (ExtensionDeclaration)declarer.getDeclaration();
    }

    @Test
    public void verifyConfigurationModelPropertyOnOperation() {
        OperationDeclaration operationDeclaration = (OperationDeclaration)EnricherTestUtils.getDeclaration(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getOperations(), GET_ENEMY);
        ConfigTypeModelProperty configTypeModelProperty = EnricherTestUtils.checkIsPresent((BaseDeclaration)operationDeclaration, ConfigTypeModelProperty.class);
        this.assertType(configTypeModelProperty);
    }

    @Test
    public void verifyConfigurationModelPropertyOnSource() {
        SourceDeclaration sourceDeclaration = (SourceDeclaration)EnricherTestUtils.getDeclaration(((ConfigurationDeclaration)this.declaration.getConfigurations().get(0)).getMessageSources(), LISTEN_PAYMENTS);
        ConfigTypeModelProperty configTypeModelProperty = EnricherTestUtils.checkIsPresent((BaseDeclaration)sourceDeclaration, ConfigTypeModelProperty.class);
        this.assertType(configTypeModelProperty);
    }

    private void assertType(ConfigTypeModelProperty configTypeModelProperty) {
        MatcherAssert.assertThat((Object)configTypeModelProperty.getConfigType(), (Matcher)CoreMatchers.equalTo(HeisenbergExtension.class));
    }
}

