/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.stereotype.ComponentId;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterTypeModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class ParameterTypeModelValidatorTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, lenient=true)
    private ExtensionModel extensionModel;
    @Mock(lenient=true)
    private OperationModel operationModel;
    @Mock(lenient=true)
    private ParameterModel parameter;
    @Mock
    private ExtensionParameter extensionParameter;
    private final Type objectKey = new TypeToken<Map<Object, Object>>(){}.getType();
    private final Type stringMap = new TypeToken<Map<String, Object>>(){}.getType();
    private final Type wildcardMap = new TypeToken<Map<?, ?>>(){}.getType();
    private final Type rawMap = new TypeToken<Map>(){}.getType();
    private final ParameterTypeModelValidator validator = new ParameterTypeModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getModelProperty(CompileTimeModelProperty.class)).thenReturn(Optional.of(new CompileTimeModelProperty()));
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.parameter.getName()).thenReturn((Object)"parameter");
        Mockito.when((Object)this.parameter.getModelProperty(ExtensionParameterDescriptorModelProperty.class)).thenReturn(Optional.of(new ExtensionParameterDescriptorModelProperty(this.extensionParameter)));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.operationModel, this.parameter);
    }

    @Test
    public void objectKey() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.objectKey));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void stringKey() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.stringMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void wildcardMap() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.wildcardMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void rawMap() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(this.rawMap));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void boxedBoolean() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(Boolean.class));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void primitiveBoolean() {
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(Boolean.TYPE));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void configOverrideInPojo() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Type 'InvalidPojoWithConfigOverride' has a field with name 'overriden' declared as 'ConfigOverride', which is not allowed.");
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(InvalidPojoWithConfigOverride.class));
        Mockito.when((Object)this.extensionParameter.getType()).thenReturn((Object)new TypeWrapper(InvalidPojoWithConfigOverride.class, ExtensionsTestUtils.TYPE_LOADER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void componentIdInPojo() {
        this.expectedException.expect(IllegalModelDefinitionException.class);
        this.expectedException.expectMessage("Type 'InvalidPojoWithComponentId' has a field with name 'id' declared as 'ComponentId', which is not allowed.");
        Mockito.when((Object)this.parameter.getType()).thenReturn((Object)ExtensionsTestUtils.TYPE_LOADER.load(InvalidPojoWithComponentId.class));
        Mockito.when((Object)this.extensionParameter.getType()).thenReturn((Object)new TypeWrapper(InvalidPojoWithComponentId.class, ExtensionsTestUtils.TYPE_LOADER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    private static class InvalidPojoWithComponentId {
        @Parameter
        private String bar;
        @Parameter
        @ComponentId
        private String id;

        private InvalidPojoWithComponentId() {
        }
    }

    private static class InvalidPojoWithConfigOverride {
        @Parameter
        private String foo;
        @Parameter
        @ConfigOverride
        private String overriden;

        private InvalidPojoWithConfigOverride() {
        }
    }
}

