/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.validation.SourceCallbacksModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SourceCallbacksModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock
    ExtensionModel extensionModel;
    @Mock
    SourceModel sourceModel;
    @Mock
    ParameterModel invalidParameter;
    @Mock
    SourceCallbackModel onTerminateCallback;
    @Mock
    SourceCallbackModel onErrorCallback;
    @Mock
    SourceCallbackModel onSuccessCallback;
    private ProblemsReporter problemsReporter;
    private SourceCallbacksModelValidator validator;

    @Before
    public void setUp() throws Exception {
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
        this.validator = new SourceCallbacksModelValidator();
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.singletonList(this.sourceModel));
        Mockito.when((Object)this.sourceModel.getTerminateCallback()).thenReturn(Optional.of(this.onTerminateCallback));
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.empty());
    }

    @Test
    public void onTerminateWithInvalidParameter() {
        Mockito.when((Object)this.onTerminateCallback.getAllParameterModels()).thenReturn(Collections.singletonList(this.invalidParameter));
        this.validator.validate(this.extensionModel, this.problemsReporter);
        this.assertProblemContaining("@OnTerminate callback method can only receive parameters of the following types: 'SourceResult' and 'SourceCallbackContext'");
    }

    @Test
    public void onTerminateWithValidParameters() {
        Mockito.when((Object)this.onTerminateCallback.getAllParameterModels()).thenReturn(Collections.emptyList());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        MatcherAssert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }

    @Test
    public void sourcesWithCallbacksShouldDefineOnTerminate() {
        Mockito.when((Object)this.sourceModel.getTerminateCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.onSuccessCallback));
        this.validator.validate(this.extensionModel, this.problemsReporter);
        this.assertOnTerminateRequired();
    }

    @Test
    public void sourcesWithOnErrorCallbackWithParameterShouldDefineOnTerminate() {
        Mockito.when((Object)this.sourceModel.getTerminateCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.onErrorCallback));
        Mockito.when((Object)this.onErrorCallback.getAllParameterModels()).thenReturn(Collections.singletonList(this.invalidParameter));
        this.validator.validate(this.extensionModel, this.problemsReporter);
        this.assertOnTerminateRequired();
    }

    private void assertOnTerminateRequired() {
        this.assertProblemContaining(String.format("another method annotated with @%s is required", OnTerminate.class.getSimpleName()));
    }

    @Test
    public void sourcesWithParameterlessOnErrorCallback() {
        Mockito.when((Object)this.sourceModel.getTerminateCallback()).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.onSuccessCallback));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.onErrorCallback));
        this.validator.validate(this.extensionModel, this.problemsReporter);
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }

    private void assertProblemContaining(String substring) {
        List errors = this.problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty())));
        Problem problem = (Problem)errors.get(0);
        MatcherAssert.assertThat((Object)problem.getComponent(), (Matcher)CoreMatchers.is((Object)this.sourceModel));
        MatcherAssert.assertThat((Object)problem.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.containsString((String)substring)));
    }
}

