/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.TestTimeSupplier;

@SmallTest
@RunWith(value=Parameterized.class)
public class LifecycleAwareConfigurationInstanceTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    protected static final int RECONNECTION_MAX_ATTEMPTS = 5;
    private static final int RECONNECTION_FREQ = 100;
    private static final String NAME = "name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private ConfigurationState configurationState;
    @Mock
    protected ConnectionManagerAdapter connectionManager;
    protected Lifecycle value = (Lifecycle)Mockito.mock(Lifecycle.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}));
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected Optional<ConnectionProvider> connectionProvider;
    protected LifecycleAwareConfigurationInstance configurationInstance;
    protected Injector injector;
    private final TestTimeSupplier timeSupplier = new TestTimeSupplier(System.currentTimeMillis());

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"With provider", Mockito.mock(ConnectionProvider.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class, MuleContextAware.class}))}, {"Without provider", null});
    }

    public LifecycleAwareConfigurationInstanceTestCase(String name, ConnectionProvider connectionProvider) {
        this.connectionProvider = Optional.ofNullable(connectionProvider);
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap("_muleTimeSupplier", this.timeSupplier);
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new DefaultsConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                super.doConfigure(muleContext);
                this.registerObject("_muleConnectionManager", LifecycleAwareConfigurationInstanceTestCase.this.connectionManager, muleContext);
            }
        };
    }

    protected void doSetUp() throws Exception {
        this.retryPolicyTemplate = this.createRetryTemplate();
        this.retryPolicyTemplate.setNotifier((RetryNotifier)Mockito.mock(RetryNotifier.class));
        this.configurationInstance = this.createConfigurationInstance();
        this.injector = MuleTestUtils.spyInjector((MuleContext)muleContext);
        super.doSetUp();
    }

    protected RetryPolicyTemplate createRetryTemplate() {
        return new TestSimpleRetryPolicyTemplate(100L, 5);
    }

    @After
    public void after() {
        this.configurationInstance.dispose();
    }

    protected LifecycleAwareConfigurationInstance createConfigurationInstance() throws MuleException {
        if (this.connectionProvider.isPresent()) {
            this.reset(this.connectionProvider.get());
        }
        this.setup(this.connectionManager);
        return (LifecycleAwareConfigurationInstance)muleContext.getInjector().inject((Object)new LifecycleAwareConfigurationInstance(NAME, this.configurationModel, (Object)this.value, this.configurationState, this.connectionProvider));
    }

    private void setup(ConnectionManagerAdapter connectionManager) {
        if (this.connectionProvider.isPresent()) {
            Mockito.when((Object)connectionManager.getRetryTemplateFor(this.connectionProvider.get())).thenReturn((Object)this.retryPolicyTemplate);
            Mockito.when((Object)connectionManager.testConnectivity((ConfigurationInstance)Mockito.any(ConfigurationInstance.class))).thenReturn((Object)ConnectionValidationResult.success());
        }
    }

    private void reset(Object object) {
        Mockito.reset((Object[])new Object[]{object});
        if (object instanceof ConnectionManagerAdapter) {
            this.setup((ConnectionManagerAdapter)object);
        }
    }

    @Test
    public void valueInjected() throws Exception {
        this.configurationInstance.initialise();
        ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.value);
        if (this.connectionProvider.isPresent()) {
            ((Injector)Mockito.verify((Object)this.injector)).inject((Object)this.connectionProvider.get());
        } else {
            ((Injector)Mockito.verify((Object)this.injector, (VerificationMode)Mockito.never())).inject((Object)CoreMatchers.any(ConnectionProvider.class));
        }
    }

    @Test
    public void connectionBound() throws Exception {
        this.configurationInstance.initialise();
        this.assertBound();
    }

    private void assertBound() throws Exception {
        if (this.connectionProvider.isPresent()) {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.times((int)1))).bind((Object)this.value, this.connectionProvider.get());
        } else {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.never())).bind(ArgumentMatchers.same((Object)this.value), (ConnectionProvider)ArgumentMatchers.anyObject());
        }
    }

    private VerificationMode getBindingVerificationMode() {
        return this.connectionProvider.map(p -> Mockito.times((int)1)).orElse(Mockito.never());
    }

    @Test
    public void connectionReBoundfterStopStart() throws Exception {
        this.connectionBound();
        this.configurationInstance.start();
        this.configurationInstance.stop();
        ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)this.getBindingVerificationMode())).unbind((Object)this.value);
        this.reset(this.connectionManager);
        this.configurationInstance.start();
        this.assertBound();
    }

    @Test
    public void valueInitialised() throws Exception {
        this.configurationInstance.initialise();
        ((Initialisable)Mockito.verify((Object)this.value)).initialise();
        if (this.connectionProvider.isPresent()) {
            ((Initialisable)Mockito.verify((Object)((Initialisable)this.connectionProvider.get()))).initialise();
        }
    }

    @Test
    public void valueStarted() throws Exception {
        this.configurationInstance.start();
        ((Startable)Mockito.verify((Object)this.value)).start();
        if (this.connectionProvider.isPresent()) {
            ((Startable)Mockito.verify((Object)((Startable)this.connectionProvider.get()))).start();
        }
    }

    @Test
    public void testConnectivityUponStart() throws Exception {
        this.configurationInstance.initialise();
        if (this.connectionProvider.isPresent()) {
            this.valueStarted();
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).testConnectivity((ConfigurationInstance)this.configurationInstance);
        }
    }

    @Test
    public void testConnectivityFailsUponStart() throws Exception {
        if (this.connectionProvider.isPresent()) {
            ConnectionException connectionException = new ConnectionException("Oops!");
            Mockito.when((Object)this.connectionManager.testConnectivity((ConfigurationInstance)this.configurationInstance)).thenReturn((Object)ConnectionValidationResult.failure((String)connectionException.getMessage(), (Exception)connectionException));
            this.configurationInstance.initialise();
            try {
                this.configurationInstance.start();
                Assert.fail((String)"Was expecting connectivity testing to fail");
            }
            catch (Exception e) {
                ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.times((int)6))).testConnectivity((ConfigurationInstance)this.configurationInstance);
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(RetryPolicyExhaustedException.class)));
            }
        }
    }

    @Test
    public void valueStopped() throws Exception {
        this.configurationInstance.initialise();
        this.configurationInstance.start();
        this.configurationInstance.stop();
        ((Stoppable)Mockito.verify((Object)this.value)).stop();
        if (this.connectionProvider.isPresent()) {
            ((Stoppable)Mockito.verify((Object)((Stoppable)this.connectionProvider.get()))).stop();
        }
    }

    @Test
    public void connectionUnbound() throws Exception {
        this.configurationInstance.initialise();
        this.configurationInstance.start();
        this.configurationInstance.stop();
        if (this.connectionProvider.isPresent()) {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager)).unbind((Object)this.value);
        } else {
            ((ConnectionManagerAdapter)Mockito.verify((Object)this.connectionManager, (VerificationMode)Mockito.never())).unbind(ArgumentMatchers.anyObject());
        }
    }

    @Test
    public void valueDisposed() throws Exception {
        this.configurationInstance.initialise();
        this.configurationInstance.dispose();
        ((Disposable)Mockito.verify((Object)this.value)).dispose();
        if (this.connectionProvider.isPresent()) {
            ((Disposable)Mockito.verify((Object)((Disposable)this.connectionProvider.get()))).dispose();
        }
    }

    @Test
    public void getName() {
        Assert.assertThat((Object)this.configurationInstance.getName(), (Matcher)CoreMatchers.is((Object)NAME));
    }

    @Test
    public void getModel() {
        Assert.assertThat((Object)this.configurationInstance.getModel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationModel)));
    }

    @Test
    public void getValue() {
        Assert.assertThat((Object)this.configurationInstance.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.value)));
    }

    @Test(expected=IllegalStateException.class)
    public void getStatsBeforeInit() {
        this.configurationInstance.getStatistics();
    }

    @Test
    public void getStatistics() throws Exception {
        this.configurationInstance.initialise();
        Assert.assertThat((Object)this.configurationInstance.getStatistics(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void getState() {
        Assert.assertThat((Object)this.configurationInstance.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configurationState)));
    }

    private class TestSimpleRetryPolicyTemplate
    extends SimpleRetryPolicyTemplate {
        public TestSimpleRetryPolicyTemplate(long frequency, int retryCount) {
            super(frequency, retryCount);
        }

        protected void computeStats() {
        }
    }
}

