/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import io.qameta.allure.Issue;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.PreservingThreadContextExecutorCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.slf4j.MDC;

@Issue(value="MULE-19097")
public class PreservingThreadContextExecutorCallbackTestCase
extends AbstractMuleTestCase {
    @Mock
    private CompletableComponentExecutor.ExecutorCallback executorCallback = (CompletableComponentExecutor.ExecutorCallback)Mockito.mock(CompletableComponentExecutor.ExecutorCallback.class);

    @Test
    public void preserveClassLoaderOnError() {
        Reference preservingCtxExecutorCallbackRef = new Reference();
        ClassLoader onCreationClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)onCreationClassLoader, () -> preservingCtxExecutorCallbackRef.set((Object)new PreservingThreadContextExecutorCallback(this.executorCallback)));
        Reference onErrorClassLoaderRef = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            onErrorClassLoaderRef.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        }).when((Object)this.executorCallback)).error((Throwable)ArgumentMatchers.any());
        ClassLoader anotherClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)anotherClassLoader, () -> ((PreservingThreadContextExecutorCallback)preservingCtxExecutorCallbackRef.get()).error((Throwable)new NullPointerException()));
        Assert.assertThat((Object)onErrorClassLoaderRef.get(), (Matcher)CoreMatchers.is((Object)onCreationClassLoader));
    }

    @Test
    public void preserveClassLoaderOnComplete() {
        Reference preservingCtxExecutorCallbackRef = new Reference();
        ClassLoader onCreationClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)onCreationClassLoader, () -> preservingCtxExecutorCallbackRef.set((Object)new PreservingThreadContextExecutorCallback(this.executorCallback)));
        Reference onCompleteClassLoaderRef = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            onCompleteClassLoaderRef.set((Object)Thread.currentThread().getContextClassLoader());
            return null;
        }).when((Object)this.executorCallback)).complete(ArgumentMatchers.any());
        ClassLoader anotherClassLoader = (ClassLoader)Mockito.mock(ClassLoader.class);
        ClassUtils.withContextClassLoader((ClassLoader)anotherClassLoader, () -> ((PreservingThreadContextExecutorCallback)preservingCtxExecutorCallbackRef.get()).complete(null));
        Assert.assertThat((Object)onCompleteClassLoaderRef.get(), (Matcher)CoreMatchers.is((Object)onCreationClassLoader));
    }

    @Test
    public void preserveMDCOnError() {
        Reference preservingCtxExecutorCallbackRef = new Reference();
        Map<String, String> onCreationMap = Collections.singletonMap("on", "creation");
        this.withMDC(onCreationMap, () -> preservingCtxExecutorCallbackRef.set((Object)new PreservingThreadContextExecutorCallback(this.executorCallback)));
        Reference onErrorMDCRef = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            onErrorMDCRef.set((Object)MDC.getCopyOfContextMap());
            return null;
        }).when((Object)this.executorCallback)).error((Throwable)ArgumentMatchers.any());
        Map<String, String> anotherMap = Collections.singletonMap("on", "another");
        this.withMDC(anotherMap, () -> ((PreservingThreadContextExecutorCallback)preservingCtxExecutorCallbackRef.get()).error((Throwable)new NullPointerException()));
        Assert.assertThat(((Map)onErrorMDCRef.get()).get("on"), (Matcher)CoreMatchers.is((Object)"creation"));
    }

    @Test
    public void preserveMDCOnComplete() {
        Reference preservingCtxExecutorCallbackRef = new Reference();
        Map<String, String> onCreationMap = Collections.singletonMap("on", "creation");
        this.withMDC(onCreationMap, () -> preservingCtxExecutorCallbackRef.set((Object)new PreservingThreadContextExecutorCallback(this.executorCallback)));
        Reference onCompleteMDCRef = new Reference();
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.doAnswer(ignored -> {
            onCompleteMDCRef.set((Object)MDC.getCopyOfContextMap());
            return null;
        }).when((Object)this.executorCallback)).complete(ArgumentMatchers.any());
        Map<String, String> anotherMap = Collections.singletonMap("on", "another");
        this.withMDC(anotherMap, () -> ((PreservingThreadContextExecutorCallback)preservingCtxExecutorCallbackRef.get()).complete(null));
        Assert.assertThat(((Map)onCompleteMDCRef.get()).get("on"), (Matcher)CoreMatchers.is((Object)"creation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withMDC(Map<String, String> mdc, Runnable callback) {
        Map oldMDC = MDC.getCopyOfContextMap();
        MDC.setContextMap(mdc);
        try {
            callback.run();
        }
        finally {
            MDC.setContextMap((Map)oldMDC);
        }
    }
}

