/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.notification;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.module.extension.internal.runtime.notification.DefaultExtensionNotification;
import org.mule.sdk.api.notification.NotificationActionDefinition;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.heisenberg.extension.HeisenbergNotificationAction;

public class DefaultExtensionNotificationTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-16288302")
    @Description(value="When DefaultExtensionNotification calls getAction() with a NullComponent, component.getLocation().getComponentIdentifier() does not throw a NullPointerException and the action is created.")
    public void getActionWhenTheComponentIsANullComponent() {
        AbstractComponent nullComponent = (AbstractComponent)Mockito.mock(AbstractComponent.class);
        Mockito.when((Object)nullComponent.getLocation()).thenReturn(null);
        TypedValue typedValue = new TypedValue((Object)"", HeisenbergNotificationAction.NEW_BATCH.getDataType());
        DefaultExtensionNotification notification = new DefaultExtensionNotification(null, (Component)nullComponent, (NotificationActionDefinition)HeisenbergNotificationAction.NEW_BATCH, typedValue);
        Notification.Action action = notification.getAction();
        MatcherAssert.assertThat((Object)action.getNamespace(), (Matcher)Matchers.is((Object)"NULL"));
        MatcherAssert.assertThat((Object)action.getIdentifier(), (Matcher)Matchers.is((Object)"NEW_BATCH"));
    }
}

