/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.result;

import java.nio.charset.Charset;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.result.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.TargetReturnDelegate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
public class TargetOutputMessageReturnDelegateTestCase
extends AbstractMuleContextTestCase {
    private static final String TARGET = "myFlowVar";
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    private ExpressionManager expressionManager;
    @Mock(lenient=true)
    protected ExecutionContextAdapter operationContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    protected ComponentModel componentModel;
    @Mock
    protected Component component;
    protected CoreEvent event;
    @Mock
    private StreamingManager streamingManager;
    @Mock
    protected Object attributes;
    protected ReturnDelegate delegate;
    private final Object payload = "hello world!";

    @Before
    public void before() throws MuleException {
        this.expressionManager = muleContext.getExpressionManager();
        this.event = MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.builder().value((Object)"").attributesValue(this.attributes).build()).build();
        Mockito.when((Object)this.operationContext.getEvent()).thenReturn((Object)this.event);
        Mockito.when((Object)this.operationContext.getMuleContext()).thenReturn((Object)muleContext);
        Mockito.when((Object)this.operationContext.getComponent()).thenReturn((Object)this.component);
        Mockito.when((Object)this.componentModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.empty());
    }

    private TargetReturnDelegate createDelegate(String expression) {
        return new TargetReturnDelegate(TARGET, expression, this.componentModel, this.expressionManager, (CursorProviderFactory)ExtensionsTestUtils.getDefaultCursorStreamProviderFactory(), muleContext, this.streamingManager);
    }

    @Test
    public void operationTargetMessage() {
        this.delegate = this.createDelegate("#[message]");
        CoreEvent result = this.delegate.asReturnValue(this.payload, this.operationContext);
        this.assertMessage(result.getMessage());
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Message.class)));
        Message message = (Message)((TypedValue)result.getVariables().get(TARGET)).getValue();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)this.payload));
    }

    @Test
    public void operationTargetMessageWithDefaultMimeType() {
        Mockito.when((Object)this.componentModel.getModelProperty(MediaTypeModelProperty.class)).thenReturn(Optional.of(new MediaTypeModelProperty(MediaType.APPLICATION_JSON.toRfcString(), true)));
        this.delegate = this.createDelegate("#[message]");
        CoreEvent result = this.delegate.asReturnValue(this.payload, this.operationContext);
        this.assertMessage(result.getMessage());
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Message.class)));
        Message message = (Message)((TypedValue)result.getVariables().get(TARGET)).getValue();
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)this.payload));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType().toRfcString(), (Matcher)CoreMatchers.containsString((String)MediaType.APPLICATION_JSON.toRfcString()));
    }

    @Test
    public void operationTargetPayload() {
        this.delegate = this.createDelegate("#[payload]");
        CoreEvent result = this.delegate.asReturnValue(this.payload, this.operationContext);
        this.assertMessage(result.getMessage());
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getValue(), (Matcher)CoreMatchers.is((Object)this.payload));
    }

    @Test
    public void operationTargetPayloadWithResult() {
        this.delegate = this.createDelegate("#[payload]");
        MediaType mediaType = MediaType.APPLICATION_JSON.withCharset(Charset.defaultCharset());
        CoreEvent result = this.delegate.asReturnValue((Object)Result.builder().output(this.payload).mediaType(mediaType).build(), this.operationContext);
        this.assertMessage(result.getMessage());
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getValue(), (Matcher)CoreMatchers.is((Object)this.payload));
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)mediaType));
    }

    private void assertMessage(Message message) {
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Object)this.attributes));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }
}

