/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.internal.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.factory.InMemoryCursorStreamProviderFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.streaming.bytes.SimpleByteBufferManager;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeHandlerManagerFactory;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandlerFactory;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public final class ExtensionsTestUtils {
    public static final ClassTypeLoader TYPE_LOADER = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    public static final BaseTypeBuilder TYPE_BUILDER = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    public static final String HELLO_WORLD = "Hello World!";

    private ExtensionsTestUtils() {
    }

    public static MetadataType toMetadataType(Class<?> type) {
        return TYPE_LOADER.load(type);
    }

    public static ProblemsReporter validate(Class<?> clazz, ExtensionModelValidator validator) {
        return ExtensionsTestUtils.validate(MuleExtensionUtils.loadExtension(clazz, (Map)new SmallMap()), validator);
    }

    public static ProblemsReporter validate(Class<?> clazz, ExtensionModelValidator validator, Map<String, Object> params) {
        return ExtensionsTestUtils.validate(MuleExtensionUtils.loadExtension(clazz, params), validator);
    }

    public static ProblemsReporter validate(ExtensionModel model, ExtensionModelValidator validator) {
        ProblemsReporter problemsReporter = new ProblemsReporter(model);
        validator.validate(model, problemsReporter);
        if (problemsReporter.hasErrors()) {
            throw new IllegalModelDefinitionException(problemsReporter.toString());
        }
        return problemsReporter;
    }

    public static ArrayType arrayOf(Class<? extends Collection> clazz, TypeBuilder itemType) {
        return TYPE_BUILDER.arrayType().of(itemType).with((TypeAnnotation)new ClassInformationAnnotation(clazz)).build();
    }

    public static ObjectType dictionaryOf(TypeBuilder<?> valueTypeBuilder) {
        return TYPE_BUILDER.objectType().openWith(valueTypeBuilder).with((TypeAnnotation)new ClassInformationAnnotation(Map.class)).build();
    }

    public static TypeBuilder<?> objectTypeBuilder(Class<?> clazz) {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        TypeHandlerManager typeHandlerManager = new ExtensionsTypeHandlerManagerFactory().createTypeHandlerManager();
        typeHandlerManager.handle(clazz, new ParsingContext(), typeBuilder);
        return typeBuilder;
    }

    public static ValueResolver getResolver(Object value) throws Exception {
        return ExtensionsTestUtils.getResolver(value, null, true, new Class[0]);
    }

    public static ValueResolver getResolver(Object value, ValueResolvingContext context, boolean dynamic, Class<?> ... extraInterfaces) throws Exception {
        ValueResolver resolver = ArrayUtils.isEmpty((Object[])extraInterfaces) ? (ValueResolver)Mockito.mock(ValueResolver.class) : (ValueResolver)Mockito.mock(ValueResolver.class, (MockSettings)Mockito.withSettings().extraInterfaces((Class[])extraInterfaces));
        Mockito.when((Object)resolver.resolve(context != null ? (ValueResolvingContext)ArgumentMatchers.same((Object)context) : (ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn(value);
        Mockito.when((Object)resolver.isDynamic()).thenReturn((Object)dynamic);
        return resolver;
    }

    public static void assertMessageType(MetadataType type, MetadataType payloadType, MetadataType attributesType) {
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessageMetadataType.class)));
        Assert.assertThat(ExtensionMetadataTypeUtils.getId((MetadataType)type).get(), (Matcher)CoreMatchers.is((Object)Message.class.getName()));
        MessageMetadataType messageType = (MessageMetadataType)type;
        Assert.assertThat(messageType.getPayloadType().get(), (Matcher)CoreMatchers.equalTo((Object)payloadType));
        Assert.assertThat(messageType.getAttributesType().get(), (Matcher)CoreMatchers.equalTo((Object)attributesType));
    }

    public static void assertMessageType(MetadataType type, Matcher payloadMatch, Matcher attributesMatcher) {
        Assert.assertThat((Object)type, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(MessageMetadataType.class)));
        Assert.assertThat(ExtensionMetadataTypeUtils.getId((MetadataType)type).get(), (Matcher)CoreMatchers.is((Object)Message.class.getName()));
        MessageMetadataType messageType = (MessageMetadataType)type;
        Assert.assertThat(messageType.getPayloadType().get(), (Matcher)payloadMatch);
        Assert.assertThat(messageType.getAttributesType().get(), (Matcher)attributesMatcher);
    }

    public static ParameterModel getParameter(String name, Class<?> type) {
        ParameterModel parameterModel = ExtensionsTestUtils.getParameter();
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(type));
        Mockito.when((Object)parameterModel.getLayoutModel()).thenReturn(Optional.empty());
        return parameterModel;
    }

    public static ParameterModel getParameter(String name, MetadataType metadataType) {
        ParameterModel parameterModel = ExtensionsTestUtils.getParameter();
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)name);
        Mockito.when((Object)parameterModel.getType()).thenReturn((Object)metadataType);
        return parameterModel;
    }

    private static ParameterModel getParameter() {
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)parameterModel.getModelProperty((Class)ArgumentMatchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)parameterModel.getDslConfiguration()).thenReturn((Object)ParameterDslConfiguration.getDefaultInstance());
        Mockito.when((Object)parameterModel.getRole()).thenReturn((Object)ParameterRole.BEHAVIOUR);
        return parameterModel;
    }

    public static void stubRegistryKeys(MuleContext muleContext, String ... keys) {
        Mockito.when((Object)((MuleContextWithRegistry)muleContext).getRegistry().get(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String name = (String)invocation.getArguments()[0];
            if (name != null) {
                for (String key : keys) {
                    if (!name.contains(key)) continue;
                    return null;
                }
            }
            return Answers.RETURNS_DEEP_STUBS.get().answer(invocation);
        });
    }

    public static <C> C getConfigurationFromRegistry(String key, CoreEvent muleEvent, MuleContext muleContext) throws Exception {
        return (C)ExtensionsTestUtils.getConfigurationInstanceFromRegistry(key, muleEvent, muleContext).getValue();
    }

    public static ConfigurationInstance getConfigurationInstanceFromRegistry(String key, CoreEvent muleEvent, MuleContext muleContext) throws Exception {
        ExtensionManager extensionManager = muleContext.getExtensionManager();
        return extensionManager.getConfiguration(key, muleEvent);
    }

    public static void compareXML(String expected, String actual) throws Exception {
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)false);
        Diff diff = XMLUnit.compareXML((String)expected, (String)actual);
        if (!diff.similar() || !diff.identical()) {
            System.out.println(actual);
            DetailedDiff detDiff = new DetailedDiff(diff);
            List differences = detDiff.getAllDifferences();
            StringBuilder diffLines = new StringBuilder();
            for (Object object : differences) {
                Difference difference = (Difference)object;
                diffLines.append(difference.toString() + '\n');
            }
            throw new IllegalArgumentException("Actual XML differs from expected: \n" + diffLines.toString());
        }
    }

    public static void mockClassLoaderModelProperty(ExtensionModel extensionModel, ClassLoader classLoader) {
        Mockito.when((Object)extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.of(new ClassLoaderModelProperty(classLoader)));
    }

    public static void setRequires(EnrichableModel model, boolean requiresConfig, boolean requiresConnection) {
        if (requiresConfig) {
            Mockito.when((Object)model.getModelProperty(ConfigTypeModelProperty.class)).thenReturn(Optional.of(Mockito.mock(ConfigTypeModelProperty.class)));
        }
        if (requiresConnection) {
            Mockito.when((Object)model.getModelProperty(ConnectivityModelProperty.class)).thenReturn(Optional.of(Mockito.mock(ConnectivityModelProperty.class)));
        }
    }

    public static void mockSubTypes(ExtensionModel mockModel, SubTypesModel ... subtypes) {
        if (ArrayUtils.isEmpty((Object[])subtypes)) {
            Mockito.when((Object)mockModel.getSubTypes()).thenReturn(Collections.emptySet());
        } else {
            Mockito.when((Object)mockModel.getSubTypes()).thenReturn((Object)ImmutableSet.copyOf((Object[])subtypes));
        }
    }

    public static ParameterGroupModel mockParameters(ParameterizedModel parameterizedModel, ParameterModel ... parameterModels) {
        return ExtensionsTestUtils.mockParameters(parameterizedModel, "General", parameterModels);
    }

    public static ParameterGroupModel mockParameters(ParameterizedModel parameterizedModel, String groupName, ParameterModel ... parameterModels) {
        ParameterGroupModel group = (ParameterGroupModel)Mockito.mock(ParameterGroupModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)group.getName()).thenReturn((Object)groupName);
        Mockito.when((Object)group.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)parameterizedModel.getParameterGroupModels()).thenReturn(Arrays.asList(group));
        Mockito.when((Object)group.getParameterModels()).thenReturn(Arrays.asList(parameterModels));
        Mockito.when((Object)parameterizedModel.getAllParameterModels()).thenReturn(Arrays.asList(parameterModels));
        return group;
    }

    public static ParameterGroupDeclaration mockParameters(ParameterizedDeclaration declaration, ParameterDeclaration ... parameters) {
        return ExtensionsTestUtils.mockParameters(declaration, "General", parameters);
    }

    public static ParameterGroupDeclaration mockParameters(ParameterizedDeclaration declaration, String groupName, ParameterDeclaration ... parameters) {
        ParameterGroupDeclaration group = (ParameterGroupDeclaration)Mockito.mock(ParameterGroupDeclaration.class);
        Mockito.when((Object)group.getName()).thenReturn((Object)groupName);
        Mockito.when((Object)declaration.getParameterGroups()).thenReturn(Arrays.asList(group));
        Mockito.when((Object)declaration.getParameterGroup(groupName)).thenReturn((Object)group);
        ArrayList<ParameterDeclaration> params = new ArrayList<ParameterDeclaration>(Arrays.asList(parameters));
        Mockito.when((Object)group.getParameters()).thenReturn(params);
        Mockito.when((Object)declaration.getAllParameters()).thenReturn(params);
        return group;
    }

    public static void mockExceptionEnricher(EnrichableModel enrichableModel, ExceptionHandlerFactory exceptionHandlerFactory) {
        Optional property = exceptionHandlerFactory != null ? Optional.of(new ExceptionHandlerModelProperty(exceptionHandlerFactory)) : Optional.empty();
        Mockito.when((Object)enrichableModel.getModelProperty(ExceptionHandlerModelProperty.class)).thenReturn(property);
    }

    public static void mockConfigurationInstance(ConfigurationModel configurationModel, Object config) {
        ConfigurationFactory configurationFactory = (ConfigurationFactory)Mockito.mock(ConfigurationFactory.class);
        Mockito.when((Object)configurationFactory.newInstance()).thenReturn(config);
        Mockito.when((Object)configurationFactory.getObjectType()).thenReturn(config.getClass());
        Mockito.when((Object)configurationModel.getModelProperty((Class)ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            Class propertyType = (Class)invocationOnMock.getArguments()[0];
            if (ConfigurationFactoryModelProperty.class.equals((Object)propertyType)) {
                return Optional.of(new ConfigurationFactoryModelProperty(configurationFactory));
            }
            return Optional.empty();
        });
    }

    public static void mockMetadataResolverFactory(EnrichableModel model, MetadataResolverFactory factory) {
        Optional property = factory != null ? Optional.of(new MetadataResolverFactoryModelProperty(() -> factory)) : Optional.empty();
        Mockito.when((Object)model.getModelProperty(MetadataResolverFactoryModelProperty.class)).thenReturn(property);
    }

    public static void mockExecutorFactory(OperationModel operationModel, CompletableComponentExecutorFactory operationExecutorFactory) {
        Mockito.when((Object)operationModel.getModelProperty(CompletableComponentExecutorModelProperty.class)).thenReturn(Optional.of(new CompletableComponentExecutorModelProperty(operationExecutorFactory)));
    }

    public static CursorStreamProviderFactory getDefaultCursorStreamProviderFactory(StreamingManager streamingManager) {
        return streamingManager.forBytes().getDefaultCursorProviderFactory();
    }

    public static CursorStreamProviderFactory getDefaultCursorStreamProviderFactory() {
        return new InMemoryCursorStreamProviderFactory((ByteBufferManager)new SimpleByteBufferManager(), InMemoryCursorStreamConfig.getDefault(), (StreamingManager)Mockito.mock(StreamingManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
    }

    public static void assertType(MetadataType metadataType, Class<?> expectedRawType, Class<? extends MetadataType> typeQualifier) {
        Assert.assertThat((Object)metadataType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(typeQualifier)));
        ExtensionMetadataTypeUtils.getType((MetadataType)metadataType).ifPresent(type -> Assert.assertThat((Object)expectedRawType.isAssignableFrom((Class<?>)type), (Matcher)CoreMatchers.is((Object)true)));
    }

    public static void mockImplementingType(EnrichableModel model, Class<?> type) {
        Mockito.when((Object)model.getModelProperty(ImplementingTypeModelProperty.class)).thenReturn(Optional.of(new ImplementingTypeModelProperty(type)));
    }

    public static ConnectionProviderDeclaration findConnectionProvider(ConfigurationDeclaration configurationDeclaration, String connectionProviderName) {
        return (ConnectionProviderDeclaration)CollectionUtils.find((Collection)configurationDeclaration.getConnectionProviders(), connectionProvider -> ((ConnectionProviderDeclaration)connectionProvider).getName().equals(connectionProviderName));
    }
}

