/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collections;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.IgnoredExtensionParameterModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class IgnoredExtensionParameterModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private ExtensionElement extensionElement;
    @Mock
    private ConfigurationElement configurationElement;
    @Mock
    private ExtensionParameter extensionParameter;
    @Mock
    private ExtensionParameter anotherExtensionParameter;
    private ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private IgnoredExtensionParameterModelValidator validator = new IgnoredExtensionParameterModelValidator();
    ProblemsReporter problemsReporter;

    @Before
    public void setup() {
        Mockito.when((Object)this.extensionElement.getParameters()).thenReturn(Collections.singletonList(this.extensionParameter));
        Mockito.when((Object)this.extensionElement.getParameterGroups()).thenReturn(Collections.singletonList(this.anotherExtensionParameter));
        Mockito.when((Object)this.extensionElement.getConfigurations()).thenReturn(Collections.singletonList(this.configurationElement));
        Mockito.when((Object)this.extensionModel.getModelProperty(CompileTimeModelProperty.class)).thenReturn(Optional.of(new CompileTimeModelProperty()));
        Mockito.when((Object)this.extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class)).thenReturn(Optional.of(new ExtensionTypeDescriptorModelProperty((Type)this.extensionElement)));
        this.problemsReporter = new ProblemsReporter(this.extensionModel);
    }

    @Test
    public void extensionWithParameterAndParameterGroupAndConfigurations() {
        this.validator.validate(this.extensionModel, this.problemsReporter);
        Assert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.isWarning("parameter"), this.isWarning("parameter group")}));
    }

    @Test
    public void extensionWithParameterAndConfigurations() {
        Mockito.when((Object)this.extensionElement.getParameterGroups()).thenReturn(Collections.emptyList());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        Assert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.contains((Matcher)this.isWarning("parameter")));
    }

    @Test
    public void extensionWithParameterGroupAndConfigurations() {
        Mockito.when((Object)this.extensionElement.getParameters()).thenReturn(Collections.emptyList());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        Assert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.contains((Matcher)this.isWarning("parameter group")));
    }

    @Test
    public void extensionWitNoParameterNorParameterGroupAndConfigurations() {
        Mockito.when((Object)this.extensionElement.getParameters()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionElement.getParameterGroups()).thenReturn(Collections.emptyList());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        Assert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void extensionWithParameterAndConfigurationsNotAtCompileTime() {
        Mockito.when((Object)this.extensionModel.getModelProperty(CompileTimeModelProperty.class)).thenReturn(Optional.empty());
        this.validator.validate(this.extensionModel, this.problemsReporter);
        Assert.assertThat((Object)this.problemsReporter.getErrors(), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.problemsReporter.getWarnings(), (Matcher)Matchers.hasSize((int)0));
    }

    private Matcher isWarning(String parameterType) {
        return CoreMatchers.allOf((Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)(parameterType + "(s) will be ignored"))), (Matcher)Matchers.hasProperty((String)"component", (Matcher)CoreMatchers.is((Object)this.extensionModel)));
    }
}

