/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.HashMap;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.internal.management.stats.NoOpCursorComponentDecoratorFactory;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.AbstractCompletableMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.ExecutorCompletionCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.execution.PreservingThreadContextExecutorCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractCompletableMethodOperationExecutorTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="MULE-18124")
    @Description(value="Verify that when a non-blocking operation method throws an exception, the callback#error method is called only once.")
    public void nonBlockingThrowsException() throws NoSuchMethodException, SecurityException {
        final NullPointerException expected = new NullPointerException("Expected");
        AbstractCompletableMethodOperationExecutor<ComponentModel> executor = new AbstractCompletableMethodOperationExecutor<ComponentModel>((ComponentModel)Mockito.mock(ComponentModel.class), ((Object)((Object)this)).getClass().getDeclaredMethod("nonBlockingThrowsException", new Class[0]), null, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE){

            protected void doExecute(ExecutionContext<ComponentModel> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
                ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
                context.setVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM", (Object)new ExecutorCompletionCallbackAdapter((CompletableComponentExecutor.ExecutorCallback)new PreservingThreadContextExecutorCallback(callback)));
                throw expected;
            }
        };
        HashMap ctxVariables = new HashMap();
        ExecutionContextAdapter ctx = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class);
        Mockito.when((Object)ctx.getVariable((String)ArgumentMatchers.any(String.class))).thenAnswer(inv -> ctxVariables.get(inv.getArgument(0)));
        Mockito.when((Object)ctx.setVariable((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any())).thenAnswer(inv -> ctxVariables.put(inv.getArgument(0), inv.getArgument(1)));
        CompletableComponentExecutor.ExecutorCallback callback = (CompletableComponentExecutor.ExecutorCallback)Mockito.mock(CompletableComponentExecutor.ExecutorCallback.class);
        executor.execute((ExecutionContext)ctx, callback);
        ((CompletableComponentExecutor.ExecutorCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).error((Throwable)expected);
    }
}

