/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution.executor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.executor.MethodExecutorGenerator;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;

public class MethodExecutorGeneratorTestCase {
    private MethodExecutorGenerator generator = new MethodExecutorGenerator();

    @Test
    public void sameMethodGeneratesUniqueClass() {
        Method method = this.getMethod("sampleOperation");
        MethodExecutor executor1 = this.generator.generate((Object)this, method, this.mockArgumentResolverDelegate(method));
        MethodExecutor executor2 = this.generator.generate((Object)this, method, this.mockArgumentResolverDelegate(method));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)executor2))));
        Assert.assertThat(executor1.getClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(executor2.getClass())));
    }

    @Test
    public void differentMethodsGenerateDifferentClasses() {
        Method method1 = this.getMethod("sampleOperation");
        Method method2 = this.getMethod("anotherOperation");
        MethodExecutor executor1 = this.generator.generate((Object)this, method1, this.mockArgumentResolverDelegate(method1));
        MethodExecutor executor2 = this.generator.generate((Object)this, method2, this.mockArgumentResolverDelegate(method2));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)executor1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)executor2))));
        Assert.assertThat(executor1.getClass(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(executor2.getClass()))));
    }

    private Method getMethod(String methodName) {
        return Stream.of(this.getClass().getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().get();
    }

    public InputStream sampleOperation(@Config MethodExecutorGeneratorTestCase config, String param1, Map<String, Object> map, StreamingHelper streamingHelper) {
        return new ByteArrayInputStream(param1.getBytes());
    }

    public String anotherOperation(@Config MethodExecutorGeneratorTestCase config, int param1) {
        return "" + param1;
    }

    private ArgumentResolverDelegate mockArgumentResolverDelegate(Method method) {
        ArgumentResolverDelegate delegate = (ArgumentResolverDelegate)Mockito.mock(ArgumentResolverDelegate.class);
        ArgumentResolver[] resolvers = new ArgumentResolver[method.getParameterCount()];
        for (int i = 0; i < method.getParameterCount(); ++i) {
            resolvers[i] = (ArgumentResolver)Mockito.mock(ArgumentResolver.class);
        }
        Mockito.when((Object)delegate.getArgumentResolvers()).thenReturn((Object)resolvers);
        return delegate;
    }
}

