/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.management.stats.NoOpCursorComponentDecoratorFactory;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkMethodInvocationException;
import org.mule.runtime.module.extension.internal.runtime.execution.deprecated.ReactiveMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.model.HealthStatus;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
public class NonCompletableMethodOperationExecutorTestCase
extends AbstractMuleContextTestCase {
    private static final String CONFIG_NAME = "config";
    private static final DataType DATA_TYPE = DataType.STRING;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private CoreEvent muleEvent;
    @Mock
    private ResolverSetResult parameters;
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ExtensionManager extensionManager;
    @Mock
    private CursorProviderFactory cursorProviderFactory;
    @Mock
    private CursorComponentDecoratorFactory componentDecoratorFactory;
    @Mock
    private StreamingManager streamingManager;
    @Mock
    private Component component;
    @Mock
    private ConfigurationState configurationState;
    @Mock
    private RetryPolicyTemplate retryPolicyTemplate;
    private ReactiveMethodOperationExecutor executor;
    private ConfigurationInstance configurationInstance;
    private ExecutionContextAdapter operationContext;
    private HeisenbergExtension config;
    private HeisenbergOperations operations;
    private final PrimitiveTypesTestOperations primitiveTypesTestOperations = new PrimitiveTypesTestOperations();

    @Before
    public void init() throws Exception {
        this.initHeisenberg();
        this.configurationInstance = new LifecycleAwareConfigurationInstance(CONFIG_NAME, this.configurationModel, (Object)this.config, this.configurationState, Optional.empty());
        Mockito.when((Object)this.muleEvent.getMessage().getPayload()).thenReturn((Object)new TypedValue(null, DATA_TYPE));
        Mockito.when((Object)this.operationModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        this.operationContext = new DefaultExecutionContext(this.extensionModel, Optional.of(this.configurationInstance), this.parameters.asMap(), (ComponentModel)this.operationModel, this.muleEvent, this.cursorProviderFactory, this.componentDecoratorFactory, this.streamingManager, this.component, this.retryPolicyTemplate, ImmediateScheduler.IMMEDIATE_SCHEDULER, Optional.empty(), muleContext);
        this.operationContext = (ExecutionContextAdapter)Mockito.spy((Object)this.operationContext);
    }

    @Test
    public void operationWithReturnValueAndWithoutParameters() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"sayMyName", (Class[])new Class[]{HeisenbergExtension.class});
        this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.operations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
        LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
        this.assertResult(this.execute(), "Heisenberg");
    }

    @Test
    public void exceptionIsPropagated() throws Exception {
        RuntimeException exception = new RuntimeException();
        this.operations = (HeisenbergOperations)Mockito.mock(HeisenbergOperations.class);
        Mockito.when((Object)this.operations.sayMyName((HeisenbergExtension)ArgumentMatchers.any(HeisenbergExtension.class))).thenThrow(new Throwable[]{exception});
        this.expected.expect(SdkMethodInvocationException.class);
        this.expected.expectCause(CoreMatchers.sameInstance((Object)exception));
        this.operationWithReturnValueAndWithoutParameters();
    }

    @Test
    public void voidOperationWithoutParameters() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"die", (Class[])new Class[]{HeisenbergExtension.class});
        this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.operations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
        LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
        Assert.assertThat((Object)this.execute(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.config.getEndingHealth(), (Matcher)CoreMatchers.is((Object)HealthStatus.DEAD));
    }

    @Test
    public void withArgumentsAndReturnValue() throws Exception {
        HashMap<String, Integer> parametersMap = new HashMap<String, Integer>();
        parametersMap.put("index", 0);
        Mockito.when((Object)this.parameters.asMap()).thenReturn(parametersMap);
        this.init();
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"getEnemy", (Class[])new Class[]{HeisenbergExtension.class, Integer.TYPE});
        this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.operations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
        LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
        this.assertResult(((Result)this.execute()).getOutput(), "Hank");
    }

    @Test
    public void voidWithArguments() throws Exception {
        Method method = ClassUtils.getMethod(HeisenbergOperations.class, (String)"die", (Class[])new Class[]{HeisenbergExtension.class});
        this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.operations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
        LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
        Assert.assertThat((Object)this.execute(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void withPrimitiveTypeArgumentsWithoutValue() throws Exception {
        Object[][] primitiveOperations;
        for (Object[] primitiveOperation : primitiveOperations = new Object[][]{{"charOperation", Character.TYPE}, {"byteOperation", Byte.TYPE}, {"shortOperation", Short.TYPE}, {"intOperation", Integer.TYPE}, {"longOperation", Long.TYPE}, {"floatOperation", Float.TYPE}, {"doubleOperation", Double.TYPE}, {"booleanOperation", Boolean.TYPE}}) {
            Method method = ClassUtils.getMethod(PrimitiveTypesTestOperations.class, (String)((String)primitiveOperation[0]), (Class[])new Class[]{(Class)primitiveOperation[1]});
            this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.primitiveTypesTestOperations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
            LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
            this.execute();
        }
    }

    @Test
    public void withAllPrimitiveTypeArgumentsWithoutValue() throws Exception {
        Class[] parameterTypes = new Class[]{Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE};
        Method method = ClassUtils.getMethod(PrimitiveTypesTestOperations.class, (String)"allCombined", (Class[])parameterTypes);
        this.executor = new ReactiveMethodOperationExecutor((ComponentModel)this.operationModel, method, (Object)this.primitiveTypesTestOperations, (CursorComponentDecoratorFactory)NoOpCursorComponentDecoratorFactory.NO_OP_INSTANCE);
        LifecycleUtils.initialiseIfNeeded((Object)this.executor, (boolean)true, (MuleContext)muleContext);
        this.execute();
    }

    private void initHeisenberg() {
        this.config = new HeisenbergExtension();
        this.config.getPersonalInfo().setName("Heisenberg");
        this.config.setEnemies(Arrays.asList("Hank"));
        this.operations = new HeisenbergOperations();
    }

    private void assertResult(Object value, Object expected) throws Exception {
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)expected));
    }

    private Object execute() {
        return Mono.from((Publisher)this.executor.execute((ExecutionContext)this.operationContext)).block();
    }

    public static class PrimitiveTypesTestOperations {
        private char charValue;
        private byte byteValue;
        private short shortValue;
        private int intValue;
        private long longValue;
        private float floatValue;
        private double doubleValue;
        private boolean booleanValue;

        public void charOperation(@org.mule.runtime.extension.api.annotation.param.Optional char value) {
            Assert.assertThat((Object)Character.valueOf(value), (Matcher)CoreMatchers.is((Object)Character.valueOf(this.charValue)));
        }

        public void byteOperation(@org.mule.runtime.extension.api.annotation.param.Optional byte value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.byteValue));
        }

        public void shortOperation(@org.mule.runtime.extension.api.annotation.param.Optional short value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.shortValue));
        }

        public void intOperation(@org.mule.runtime.extension.api.annotation.param.Optional int value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.intValue));
        }

        public void longOperation(@org.mule.runtime.extension.api.annotation.param.Optional long value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.longValue));
        }

        public void floatOperation(@org.mule.runtime.extension.api.annotation.param.Optional float value) {
            Assert.assertThat((Object)Float.valueOf(value), (Matcher)CoreMatchers.is((Object)Float.valueOf(this.floatValue)));
        }

        public void doubleOperation(@org.mule.runtime.extension.api.annotation.param.Optional double value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.doubleValue));
        }

        public void booleanOperation(@org.mule.runtime.extension.api.annotation.param.Optional boolean value) {
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)this.booleanValue));
        }

        public void allCombined(@org.mule.runtime.extension.api.annotation.param.Optional char charValue, @org.mule.runtime.extension.api.annotation.param.Optional byte byteValue, @org.mule.runtime.extension.api.annotation.param.Optional short shortValue, @org.mule.runtime.extension.api.annotation.param.Optional int intValue, @org.mule.runtime.extension.api.annotation.param.Optional long longValue, @org.mule.runtime.extension.api.annotation.param.Optional float floatValue, @org.mule.runtime.extension.api.annotation.param.Optional double doubleValue, @org.mule.runtime.extension.api.annotation.param.Optional boolean booleanValue) {
            Assert.assertThat((Object)Character.valueOf(charValue), (Matcher)CoreMatchers.is((Object)Character.valueOf(this.charValue)));
            Assert.assertThat((Object)byteValue, (Matcher)CoreMatchers.is((Object)this.byteValue));
            Assert.assertThat((Object)shortValue, (Matcher)CoreMatchers.is((Object)this.shortValue));
            Assert.assertThat((Object)intValue, (Matcher)CoreMatchers.is((Object)this.intValue));
            Assert.assertThat((Object)longValue, (Matcher)CoreMatchers.is((Object)this.longValue));
            Assert.assertThat((Object)Float.valueOf(floatValue), (Matcher)CoreMatchers.is((Object)Float.valueOf(this.floatValue)));
            Assert.assertThat((Object)doubleValue, (Matcher)CoreMatchers.is((Object)this.doubleValue));
            Assert.assertThat((Object)booleanValue, (Matcher)CoreMatchers.is((Object)this.booleanValue));
        }
    }
}

