/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.result;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.streaming.CursorUtils;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;
import org.mule.runtime.core.internal.streaming.bytes.ManagedCursorStreamProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.result.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.result.ValueReturnDelegateTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.weave.v2.el.ByteArrayBasedCursorStreamProvider;

@SmallTest
public class TargetReturnDelegateTestCase
extends ValueReturnDelegateTestCase {
    protected static final String TARGET = "myFlowVar";

    @Override
    protected ReturnDelegate createReturnDelegate() {
        return new TargetReturnDelegate(TARGET, "#[message]", (ComponentModel)this.componentModel, (ExpressionManager)muleContext.getExpressionManager(), this.componentDecoratorFactory, (CursorProviderFactory)this.getCursorProviderFactory(), muleContext, (StreamingManager)this.streamingManager);
    }

    @After
    public void after() {
        Assert.assertThat((Object)this.event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Override
    protected Message getOutputMessage(CoreEvent result) {
        Message message = (Message)((TypedValue)result.getVariables().get(TARGET)).getValue();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return message;
    }

    @Override
    @Test
    public void evaluateEvent() {
        CoreEvent event = (CoreEvent)Mockito.mock(CoreEvent.class);
        String payload = "Hello there!";
        Message message = Message.of((Object)"Hello there!");
        Mockito.when((Object)event.getMessage()).thenReturn((Object)message);
        CoreEvent resultEvent = this.delegate.asReturnValue((Object)event, this.operationContext);
        Message resultMessage = this.getOutputMessage(resultEvent);
        Assert.assertThat((Object)resultMessage.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Hello there!"));
    }

    @Test
    @Issue(value="MULE-19068")
    public void targetReturnDelegateShouldManageCursorStreamProvider() throws IOException {
        Mockito.when((Object)this.componentModel.supportsStreaming()).thenReturn((Object)true);
        this.delegate = new TargetReturnDelegate(TARGET, "#[payload.token]", (ComponentModel)this.componentModel, (ExpressionManager)muleContext.getExpressionManager(), this.componentDecoratorFactory, (CursorProviderFactory)this.getCursorProviderFactory(), muleContext, (StreamingManager)this.streamingManager);
        MediaType mediaType = MediaType.APPLICATION_JSON.withCharset(Charset.defaultCharset());
        Result value = Result.builder().output((Object)IOUtils.toInputStream((String)"{\"token\": \"test-token\", \"id\": \"sampleid\"}")).mediaType(mediaType).build();
        CoreEvent result = this.delegate.asReturnValue((Object)value, this.operationContext);
        Assert.assertThat((Object)((TypedValue)result.getVariables().get(TARGET)).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ManagedCursorProvider.class)));
        ManagedCursorStreamProvider cursorStreamProvider = (ManagedCursorStreamProvider)((TypedValue)result.getVariables().get(TARGET)).getValue();
        Assert.assertThat((Object)CursorUtils.unwrap((CursorProvider)cursorStreamProvider), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ByteArrayBasedCursorStreamProvider.class)));
        InputStream inputStream = (InputStream)cursorStreamProvider.openCursor();
        Assert.assertThat((Object)IOUtils.toString((InputStream)inputStream), (Matcher)CoreMatchers.is((Object)"\"test-token\""));
    }
}

