/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.SourcePolicyTestUtils;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionsFlowProcessingTemplate;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ModuleFlowProcessingTemplateTestCase
extends AbstractMuleTestCase {
    @Mock
    private SourceResultAdapter message;
    @Mock
    private CoreEvent event;
    @Mock
    private Processor messageProcessor;
    @Mock
    private SourceCompletionHandler completionHandler;
    @Mock(lenient=true)
    private MessagingException messagingException;
    @Mock
    private Map<String, Object> mockParameters;
    private final RuntimeException runtimeException = new RuntimeException();
    private ExtensionsFlowProcessingTemplate template;

    @Before
    public void before() throws Exception {
        this.template = new ExtensionsFlowProcessingTemplate(this.message, this.messageProcessor, Collections.emptyList(), this.completionHandler);
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.complete(null))).when((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (CompletableCallback)ArgumentMatchers.any());
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.complete(null))).when((Object)this.completionHandler)).onFailure((MessagingException)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (CompletableCallback)ArgumentMatchers.any());
    }

    @Test
    public void getMuleEvent() throws Exception {
        Assert.assertThat((Object)this.template.getSourceMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.message)));
    }

    @Test
    public void routeEvent() throws Exception {
        this.template.routeEvent(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).process(this.event);
    }

    @Test
    public void routeEventAsync() throws Exception {
        Mockito.when((Object)this.messageProcessor.apply((Publisher)ArgumentMatchers.any(Publisher.class))).thenReturn((Object)Mono.just((Object)this.event));
        this.template.routeEventAsync(this.event);
        ((Processor)Mockito.verify((Object)this.messageProcessor)).apply((Publisher)ArgumentMatchers.any(Publisher.class));
    }

    @Test
    public void sendResponseToClient() throws Throwable {
        Reference callbackReference = new Reference();
        SourcePolicyTestUtils.block(callback -> {
            callbackReference.set(callback);
            this.template.sendResponseToClient(this.event, this.mockParameters, callback);
        });
        Assert.assertThat((Object)callbackReference, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.same((Object)callbackReference.get()));
    }

    @Test
    public void failedToSendResponseToClient() throws Throwable {
        final Reference exceptionReference = new Reference();
        Reference callbackReference = new Reference();
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> {
            callbackReference.set(callback);
            callback.error((Throwable)this.runtimeException);
        })).when((Object)this.completionHandler)).onCompletion((CoreEvent)ArgumentMatchers.same((Object)this.event), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        try {
            SourcePolicyTestUtils.block(callback -> {
                callback = callback.before((CompletableCallback)new CompletableCallback<Void>(){

                    public void complete(Void value) {
                    }

                    public void error(Throwable e) {
                        exceptionReference.set((Object)e);
                    }
                });
                this.template.sendResponseToClient(this.event, this.mockParameters, callback);
            });
            Assert.fail((String)"This should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.runtimeException)));
        }
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler, (VerificationMode)Mockito.never())).onFailure((MessagingException)ArgumentMatchers.any(MessagingException.class), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        Assert.assertThat((Object)exceptionReference.get(), (Matcher)CoreMatchers.equalTo((Object)this.runtimeException));
    }

    @Test
    public void sendFailureResponseToClient() throws Throwable {
        Reference callbackReference = new Reference();
        SourcePolicyTestUtils.block(callback -> {
            callbackReference.set(callback);
            this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, callback);
        });
        Assert.assertThat((Object)callbackReference.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ((SourceCompletionHandler)Mockito.verify((Object)this.completionHandler)).onFailure(this.messagingException, this.mockParameters, (CompletableCallback)callbackReference.get());
    }

    @Test
    public void failedToSendFailureResponseToClient() throws Throwable {
        final Reference exceptionReference = new Reference();
        Mockito.when((Object)this.messagingException.getEvent()).thenReturn((Object)this.event);
        ((SourceCompletionHandler)Mockito.doAnswer((Answer)SourcePolicyTestUtils.onCallback(callback -> callback.error((Throwable)this.runtimeException))).when((Object)this.completionHandler)).onFailure((MessagingException)ArgumentMatchers.same((Object)this.messagingException), (Map)ArgumentMatchers.same(this.mockParameters), (CompletableCallback)ArgumentMatchers.any());
        try {
            SourcePolicyTestUtils.block(callback -> {
                callback = callback.before((CompletableCallback)new CompletableCallback<Void>(){

                    public void complete(Void value) {
                    }

                    public void error(Throwable e) {
                        exceptionReference.set((Object)e);
                    }
                });
                this.template.sendFailureResponseToClient(this.messagingException, this.mockParameters, callback);
            });
            Assert.fail((String)"This should have failed");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.runtimeException)));
        }
        Assert.assertThat((Object)exceptionReference.get(), (Matcher)CoreMatchers.equalTo((Object)this.runtimeException));
    }
}

