/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.module.extension.internal.loader.java.TypeAwareConfigurationFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;

@SmallTest
public class TypeAwareConfigurationFactoryTestCase
extends AbstractMuleTestCase {
    private ConfigurationFactory instantiator;

    @Test
    public void instantiate() {
        this.instantiator = new TypeAwareConfigurationFactory(Apple.class, Apple.class.getClassLoader());
        Object object = this.instantiator.newInstance();
        Assert.assertThat((Object)object, (Matcher)CoreMatchers.instanceOf(Apple.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void noDefaultConstructor() {
        this.instantiator = new TypeAwareConfigurationFactory(TypeAwareConfigurationFactory.class, TypeAwareConfigurationFactory.class.getClassLoader());
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullType() {
        this.instantiator = new TypeAwareConfigurationFactory(null, ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullClassLoader() {
        this.instantiator = new TypeAwareConfigurationFactory(Apple.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void interfaceType() {
        this.instantiator = new TypeAwareConfigurationFactory(InternalMessage.class, ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Test(expected=IllegalArgumentException.class)
    public void abstractClass() {
        this.instantiator = new TypeAwareConfigurationFactory(AbstractMuleTestCase.class, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

