/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.internal.loader.validator.SubtypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.JavaSubtypesModelValidator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class SubtypesModelValidatorTestCase
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    private SubtypesModelValidator validator = new SubtypesModelValidator();

    @Test
    public void validSubtypes() {
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseAbstractPojo.class), Collections.singleton(ExtensionsTestUtils.toMetadataType(Pojo.class))), new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseCustomInterface.class), Collections.singleton(ExtensionsTestUtils.toMetadataType(Pojo.class))));
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidAbstractSubtypes() {
        LinkedHashSet<SubTypesModel> subTypes = new LinkedHashSet<SubTypesModel>();
        subTypes.add(new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseAbstractPojo.class), Collections.singleton(ExtensionsTestUtils.toMetadataType(AbstractPojo.class))));
        subTypes.add(new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseCustomInterface.class), Collections.singleton(ExtensionsTestUtils.toMetadataType(CustomInterface.class))));
        Mockito.when((Object)this.extensionModel.getSubTypes()).thenReturn(subTypes);
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)new JavaSubtypesModelValidator());
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidNotSubtypesOfBaseType() {
        ExtensionsTestUtils.mockSubTypes(this.extensionModel, new SubTypesModel(ExtensionsTestUtils.toMetadataType(BaseCustomInterface.class), (Set)ImmutableSet.of((Object)ExtensionsTestUtils.toMetadataType(AbstractPojo.class), (Object)ExtensionsTestUtils.toMetadataType(CustomInterface.class))));
        Mockito.when((Object)this.extensionModel.getImportedTypes()).thenReturn(Collections.emptySet());
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    private static interface CustomInterface
    extends BaseCustomInterface {
        public String getField();
    }

    private static interface BaseCustomInterface {
        public String getBaseField();
    }

    public static class Pojo
    extends AbstractPojo
    implements CustomInterface {
        protected String childField;

        public String getChildField() {
            return this.childField;
        }

        @Override
        public String getBaseField() {
            return "";
        }

        @Override
        public String getField() {
            return "";
        }
    }

    private static abstract class AbstractPojo
    extends BaseAbstractPojo {
        protected String field;

        private AbstractPojo() {
        }

        public String getField() {
            return this.field;
        }
    }

    private static abstract class BaseAbstractPojo {
        protected String basefield;

        private BaseAbstractPojo() {
        }

        public String getBaseField() {
            return this.basefield;
        }
    }
}

