/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithDeclaringClass;
import org.mule.runtime.module.extension.internal.loader.enricher.SubTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public class SubTypesDeclarationEnricherTestCase {
    private SubTypesDeclarationEnricher enricher;
    private ExtensionDeclarer pluginDeclarer;
    private ObjectType baseMetadataType;
    private ObjectType subMetadataType;
    private AnnotationValueFetcher<SubTypeMapping> typeMapping;
    private ExtensionLoadingContext pluginCtx;
    private TypeCatalog typeCatalog;

    @Before
    public void before() {
        this.enricher = new SubTypesDeclarationEnricher();
        this.pluginDeclarer = (ExtensionDeclarer)Mockito.spy((Object)new ExtensionDeclarer());
        Type extensionType = (Type)Mockito.mock(Type.class);
        this.baseMetadataType = this.createMetadataType("base");
        this.subMetadataType = this.createMetadataType("sub");
        this.typeMapping = (AnnotationValueFetcher)Mockito.mock(AnnotationValueFetcher.class);
        Mockito.when((Object)extensionType.getValueFromAnnotation(SubTypeMapping.class)).thenReturn(Optional.of(this.typeMapping));
        this.pluginDeclarer.withModelProperty((ModelProperty)new ExtensionTypeDescriptorModelProperty(extensionType));
        this.typeCatalog = (TypeCatalog)Mockito.mock(TypeCatalog.class);
        DslResolvingContext dslResolvingCtx = (DslResolvingContext)Mockito.mock(DslResolvingContext.class);
        Mockito.when((Object)dslResolvingCtx.getTypeCatalog()).thenReturn((Object)this.typeCatalog);
        this.pluginCtx = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        Mockito.when((Object)this.pluginCtx.getExtensionDeclarer()).thenReturn((Object)this.pluginDeclarer);
        Mockito.when((Object)this.pluginCtx.getDslResolvingContext()).thenReturn((Object)dslResolvingCtx);
    }

    @Test
    @Issue(value="MULE-18581")
    @Description(value="Simulate the scenario of different plugins declaring subtypes from an underlying lib (Plugin A depends on lib X, plugin B also depends ob lib X), assert that the types from the lib are NOT imported, since they live twice, on each plugin classloader.")
    public void noImportForSubtypesFromLocalLib() throws ClassNotFoundException {
        Type baseAType = this.createType((MetadataType)this.baseMetadataType, BaseType.class);
        Type subAType = this.createType((MetadataType)this.subMetadataType, SubType.class);
        Mockito.when((Object)this.typeMapping.getClassValue((Function)ArgumentMatchers.any())).thenReturn((Object)baseAType);
        Mockito.when((Object)this.typeMapping.getClassArrayValue((Function)ArgumentMatchers.any())).thenReturn(Arrays.asList(subAType));
        Mockito.when((Object)this.typeCatalog.getType((String)ArgumentMatchers.any())).thenReturn(Optional.empty());
        this.enricher.enrich(this.pluginCtx);
        ((ExtensionDeclarer)Mockito.verify((Object)this.pluginDeclarer, (VerificationMode)Mockito.never())).withImportedType((ImportedTypeModel)ArgumentMatchers.any());
    }

    @Test
    @Issue(value="MULE-18581")
    @Description(value="Simulate the scenario of a plugins declaring subtypes from another plugin (Plugin A depends on plugin B), assert that the types from the plugin B are marked as imported on plugin A.")
    public void importForSubtypesFromOtherPlugin() throws ClassNotFoundException {
        ClassLoader otherPluginClassLoader = this.createOtherPluginClassLoader();
        Type baseAType = this.createType((MetadataType)this.baseMetadataType, otherPluginClassLoader.loadClass("base"));
        Type subAType = this.createType((MetadataType)this.subMetadataType, otherPluginClassLoader.loadClass("sub"));
        Mockito.when((Object)this.typeMapping.getClassValue((Function)ArgumentMatchers.any())).thenReturn((Object)baseAType);
        Mockito.when((Object)this.typeMapping.getClassArrayValue((Function)ArgumentMatchers.any())).thenReturn(Arrays.asList(subAType));
        Mockito.when((Object)this.typeCatalog.getType("base")).thenReturn(Optional.of(this.baseMetadataType));
        Mockito.when((Object)this.typeCatalog.getType("sub")).thenReturn(Optional.of(this.subMetadataType));
        this.enricher.enrich(this.pluginCtx);
        ((ExtensionDeclarer)Mockito.verify((Object)this.pluginDeclarer, (VerificationMode)Mockito.times((int)2))).withImportedType((ImportedTypeModel)ArgumentMatchers.any());
    }

    private ClassLoader createOtherPluginClassLoader() {
        ClassLoader otherPluginClassLoader = new ClassLoader(SubTypesDeclarationEnricherTestCase.class.getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.equals("base")) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/org/mule/runtime/module/extension/internal/loader/enricher/SubTypesDeclarationEnricherTestCase$BaseType.class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                if (name.equals("sub")) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/org/mule/runtime/module/extension/internal/loader/enricher/SubTypesDeclarationEnricherTestCase$SubType.class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        return otherPluginClassLoader;
    }

    private Type createType(MetadataType metadataType, Class declaringClass) {
        Type type = (Type)Mockito.mock(Type.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{WithDeclaringClass.class}));
        Mockito.when((Object)type.asMetadataType()).thenReturn((Object)metadataType);
        Mockito.when((Object)type.getDeclaringClass()).thenReturn(Optional.of(declaringClass));
        return type;
    }

    private ObjectType createMetadataType(String typeId) {
        ObjectType metadataType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)metadataType.getAnnotation(TypeIdAnnotation.class)).thenReturn(Optional.of(new TypeIdAnnotation(typeId)));
        ((ObjectType)Mockito.doAnswer(inv -> {
            MetadataTypeUtils.TypeResolverVisitor visitor = (MetadataTypeUtils.TypeResolverVisitor)inv.getArgument(0);
            visitor.defaultVisit((MetadataType)metadataType);
            return null;
        }).when((Object)metadataType)).accept((MetadataTypeVisitor)ArgumentMatchers.any());
        return metadataType;
    }

    public static class SubType {
    }

    public static class BaseType {
    }
}

