/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionLanguageTransformationValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExpressionLanguageTransformationValueResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String STRING_VALUE = "Hello World!";
    private static final ValueResolvingContext NULL_VALUE_RESOLVING_CONTEXT = ValueResolvingContext.builder((CoreEvent)NullEventFactory.getNullEvent()).build();
    private static final String STRING_VALUE_REPRESENTING_NUMBER = "10";
    private static final Integer NUMBER = Integer.valueOf("10");
    private static final String POJO_DESCRIPTION = "description!!!";
    private static final String POJO_DESCRIPTION_NAME = "description";
    private static final String POJO_DESCRIPTION_SCORE_NAME = "descriptionScore";
    private static final Integer POJO_DESCRIPTION_SCORE = 500;
    private static final Map<String, Object> CUSTOM_POJO_MAP_REPRESENTATION = new HashMap<String, Object>(){
        {
            this.put(ExpressionLanguageTransformationValueResolverTestCase.POJO_DESCRIPTION_NAME, ExpressionLanguageTransformationValueResolverTestCase.POJO_DESCRIPTION);
            this.put(ExpressionLanguageTransformationValueResolverTestCase.POJO_DESCRIPTION_SCORE_NAME, String.valueOf(POJO_DESCRIPTION_SCORE));
        }
    };
    private static final CustomPojo CUSTOM_POJO = new CustomPojo("description!!!", POJO_DESCRIPTION_SCORE);
    private static final String CUSTOM_POJO_JSON = String.format("{ \"%s\" : \"%s\" , \"%s\": %s }", "description", "description!!!", "descriptionScore", POJO_DESCRIPTION_SCORE);
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ExtendedExpressionManager expressionManager;

    protected void doSetUp() throws Exception {
        this.expressionManager = muleContext.getExpressionManager();
    }

    @Test
    public void noTransformationNeeded() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)STRING_VALUE), String.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)STRING_VALUE));
    }

    @Test
    public void noTransformationNeededForTypedValueValue() throws Exception {
        TypedValue typedValue = new TypedValue((Object)STRING_VALUE, DataType.STRING);
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)typedValue), String.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)typedValue));
    }

    @Test
    public void transformationNeededForSimpleType() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)STRING_VALUE_REPRESENTING_NUMBER), Integer.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)NUMBER));
    }

    @Test
    public void transformationNeededForSimpleTypeInTypedValue() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)new TypedValue((Object)STRING_VALUE_REPRESENTING_NUMBER, DataType.STRING)), Integer.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)NUMBER));
    }

    @Test
    public void transformationNeededForComplexValueInTypedValueValue() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)new TypedValue((Object)CUSTOM_POJO_JSON, DataType.JSON_STRING)), CustomPojo.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)CUSTOM_POJO));
    }

    @Test
    public void transformationNeededForComplexValue() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver(CUSTOM_POJO_MAP_REPRESENTATION), CustomPojo.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)CUSTOM_POJO));
    }

    @Test
    public void noTransformationNeededForComplexValue() throws Exception {
        ExpressionLanguageTransformationValueResolver valueResolver = new ExpressionLanguageTransformationValueResolver((ValueResolver)new StaticValueResolver((Object)CUSTOM_POJO), CustomPojo.class, (ExpressionLanguage)this.expressionManager);
        Assert.assertThat((Object)valueResolver.resolve(NULL_VALUE_RESOLVING_CONTEXT), (Matcher)CoreMatchers.equalTo((Object)CUSTOM_POJO));
    }

    public static class CustomPojo {
        private String description;
        private Integer descriptionScore;

        public CustomPojo(String description, Integer descriptionScore) {
            this.description = description;
            this.descriptionScore = descriptionScore;
        }

        public CustomPojo() {
        }

        public String getDescription() {
            return this.description;
        }

        public Integer getDescriptionScore() {
            return this.descriptionScore;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomPojo that = (CustomPojo)o;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                return false;
            }
            return this.descriptionScore != null ? this.descriptionScore.equals(that.descriptionScore) : that.descriptionScore == null;
        }

        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.descriptionScore != null ? this.descriptionScore.hashCode() : 0);
            return result;
        }
    }
}

