/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;

public class TypeSafeExpressionValueResolverTestCase
extends AbstractMuleContextTestCase {
    private static final String HELLO_WORLD = "Hello World!";
    private static final MetadataType STRING = new JavaTypeLoader(Thread.currentThread().getContextClassLoader()).load(String.class);
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ExtendedExpressionManager expressionManager;

    protected void doSetUp() throws Exception {
        muleContext = (MuleContext)Mockito.spy((Object)muleContext);
        this.expressionManager = (ExtendedExpressionManager)Mockito.spy((Object)muleContext.getExpressionManager());
        Mockito.when((Object)muleContext.getExpressionManager()).thenReturn((Object)this.expressionManager);
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject("_muleExpressionManager", (Object)this.expressionManager);
    }

    @Test
    public void expressionLanguageWithoutTransformation() throws Exception {
        ValueResolver resolver = this.getResolver("#['Hello ' ++ payload]", STRING);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"World!")).build()).withExpressionManager((ExpressionManager)this.expressionManager).build();
        this.assertResolved(resolver.resolve(ctx), HELLO_WORLD, Mockito.times((int)1));
    }

    @Test
    public void expressionTemplateWithoutTransformation() throws Exception {
        ValueResolver resolver = this.getResolver("#['Hello $(payload)']", STRING);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)"World!")).build()).withExpressionManager((ExpressionManager)this.expressionManager).build();
        this.assertResolved(resolver.resolve(ctx), HELLO_WORLD, Mockito.times((int)1));
    }

    @Test
    public void constant() throws Exception {
        ValueResolver resolver = this.getResolver(HELLO_WORLD, STRING);
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        ExpressionManagerSession session = (ExpressionManagerSession)Mockito.mock(ExpressionManagerSession.class);
        Mockito.when((Object)expressionManager.openSession((ComponentLocation)ArgumentMatchers.anyObject(), (CoreEvent)ArgumentMatchers.anyObject(), (BindingContext)ArgumentMatchers.anyObject())).thenReturn((Object)session);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build()).withExpressionManager(expressionManager).build();
        Object resolvedValue = resolver.resolve(ctx);
        this.assertResolved(resolvedValue, HELLO_WORLD, Mockito.never());
        ((ExpressionManagerSession)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).evaluate(ArgumentMatchers.anyString());
    }

    @Test
    public void expressionWithTransformation() throws Exception {
        ValueResolver resolver = this.getResolver("#[true]", STRING);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build()).withExpressionManager((ExpressionManager)this.expressionManager).build();
        this.assertResolved(resolver.resolve(ctx), "true", Mockito.times((int)1));
    }

    @Test
    public void templateWithTransformation() throws Exception {
        ValueResolver resolver = this.getResolver("#['tru$('e')']", STRING);
        ValueResolvingContext ctx = ValueResolvingContext.builder((CoreEvent)MuleContextUtils.eventBuilder((MuleContext)muleContext).message(Message.of((Object)HELLO_WORLD)).build()).withExpressionManager((ExpressionManager)this.expressionManager).build();
        this.assertResolved(resolver.resolve(ctx), "true", Mockito.times((int)1));
    }

    @Test
    public void nullExpression() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Expression cannot be blank or null");
        this.getResolver(null, STRING);
    }

    @Test
    public void blankExpression() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Expression cannot be blank or null");
        this.getResolver("", STRING);
    }

    @Test
    public void nullExpectedType() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("expected type cannot be null");
        this.getResolver("#[payload]", null);
    }

    private void assertResolved(Object resolvedValue, Object expected, VerificationMode expressionManagerVerificationMode) {
        Assert.assertThat((Object)resolvedValue, (Matcher)IsInstanceOf.instanceOf(String.class));
        Assert.assertThat((Object)resolvedValue, (Matcher)CoreMatchers.equalTo((Object)expected));
        ((ExtendedExpressionManager)Mockito.verify((Object)this.expressionManager, (VerificationMode)expressionManagerVerificationMode)).openSession((BindingContext)ArgumentMatchers.any(BindingContext.class));
    }

    private <T> ValueResolver<T> getResolver(String expression, MetadataType expectedType) throws Exception {
        TypeSafeExpressionValueResolver valueResolver = new TypeSafeExpressionValueResolver(expression, (Class)ExtensionMetadataTypeUtils.getType((MetadataType)expectedType).orElse(null), IntrospectionUtils.toDataType((MetadataType)expectedType));
        muleContext.getInjector().inject((Object)valueResolver);
        valueResolver.setExtendedExpressionManager(this.expressionManager);
        valueResolver.setTransformationService(muleContext.getTransformationService());
        valueResolver.initialise();
        return valueResolver;
    }
}

