/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.annotation.param.DefaultEncoding;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.RuntimeVersion;

public final class InjectedFieldsModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        boolean isASTMode;
        HashSet validatedTypes = new HashSet();
        boolean bl = isASTMode = extensionModel.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(mp -> mp.getType().getDeclaringClass().isPresent()).orElse(false) == false;
        if (!isASTMode) {
            extensionModel.getModelProperty(ClassLoaderModelProperty.class).ifPresent(classLoaderModelProperty -> new ExtensionWalker((ClassLoaderModelProperty)classLoaderModelProperty, validatedTypes, problemsReporter){
                final /* synthetic */ ClassLoaderModelProperty val$classLoaderModelProperty;
                final /* synthetic */ Set val$validatedTypes;
                final /* synthetic */ ProblemsReporter val$problemsReporter;
                {
                    this.val$classLoaderModelProperty = classLoaderModelProperty;
                    this.val$validatedTypes = set;
                    this.val$problemsReporter = problemsReporter;
                }

                protected void onSource(HasSourceModels owner, SourceModel model) {
                    Optional<Class> implementingType = MuleExtensionUtils.getImplementingType((EnrichableModel)model);
                    this.validateFields((NamedObject)model, implementingType, String.class, org.mule.runtime.extension.api.annotation.param.DefaultEncoding.class, DefaultEncoding.class);
                    this.validateFields((NamedObject)model, implementingType, MuleVersion.class, RuntimeVersion.class);
                }

                protected void onConfiguration(ConfigurationModel model) {
                    Optional<Class> implementingType = MuleExtensionUtils.getImplementingType((EnrichableModel)model);
                    this.validateFields((NamedObject)model, implementingType, String.class, org.mule.runtime.extension.api.annotation.param.DefaultEncoding.class, DefaultEncoding.class);
                    this.validateFields((NamedObject)model, implementingType, String.class, org.mule.runtime.extension.api.annotation.param.RefName.class, RefName.class);
                    this.validateFields((NamedObject)model, implementingType, MuleVersion.class, RuntimeVersion.class);
                }

                protected void onOperation(HasOperationModels owner, OperationModel model) {
                    this.validateArguments((NamedObject)model, model.getModelProperty(ExtensionOperationDescriptorModelProperty.class), org.mule.runtime.extension.api.annotation.param.DefaultEncoding.class, DefaultEncoding.class);
                }

                protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                    Optional<Class> implementingType = MuleExtensionUtils.getImplementingType((EnrichableModel)model);
                    this.validateFields((NamedObject)model, MuleExtensionUtils.getImplementingType((EnrichableModel)model), String.class, org.mule.runtime.extension.api.annotation.param.DefaultEncoding.class, DefaultEncoding.class);
                    this.validateFields((NamedObject)model, MuleExtensionUtils.getImplementingType((EnrichableModel)model), String.class, org.mule.runtime.extension.api.annotation.param.RefName.class, RefName.class);
                    this.validateFields((NamedObject)model, implementingType, MuleVersion.class, RuntimeVersion.class);
                }

                protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, final ParameterModel model) {
                    if (model.getType().getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
                        model.getType().accept(new MetadataTypeVisitor(){

                            public void visitObject(ObjectType objectType) {
                                if (!objectType.getAnnotation(InfrastructureTypeAnnotation.class).isPresent()) {
                                    try {
                                        Class type = JavaTypeUtils.getType((MetadataType)objectType, (ClassLoader)val$classLoaderModelProperty.getClassLoader());
                                        if (val$validatedTypes.add(type)) {
                                            this.validateType((NamedObject)model, type, String.class, new Class[]{org.mule.runtime.extension.api.annotation.param.DefaultEncoding.class, DefaultEncoding.class});
                                        }
                                    }
                                    catch (Exception e) {
                                        val$problemsReporter.addWarning(new Problem((NamedObject)model, "Could not validate Class: " + e.getMessage()));
                                    }
                                }
                            }
                        });
                    }
                }

                private void validateArguments(NamedObject model, Optional<ExtensionOperationDescriptorModelProperty> modelProperty, Class<? extends Annotation> ... annotationClasses) {
                    modelProperty.ifPresent(operationDescriptorModelProperty -> {
                        ExtensionParameter argument;
                        OperationElement operation = operationDescriptorModelProperty.getOperationElement();
                        ArrayList annotatedExtensionParameters = new ArrayList();
                        Stream.of(annotationClasses).forEach(annotationClass -> annotatedExtensionParameters.addAll(operation.getParametersAnnotatedWith((Class<? extends Annotation>)annotationClass)));
                        int size = annotatedExtensionParameters.size();
                        if (size == 0) {
                            return;
                        }
                        if (size > 1) {
                            this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' has %d arguments annotated with [@%s]. Only one argument may carry that annotation", operation.getName(), size, Stream.of(annotationClasses).map(annotationClass -> annotationClass.getName()).collect(Collectors.joining(", @")))));
                        }
                        if (!(argument = (ExtensionParameter)annotatedExtensionParameters.get(0)).getType().isSameType(String.class)) {
                            this.val$problemsReporter.addError(new Problem(model, String.format("Operation method '%s' declares an argument '%s' which is annotated with [@%s] and is of type '%s'. Only arguments of type String are allowed to carry such annotation", operation.getName(), argument.getName(), Stream.of(annotationClasses).map(annotationClass -> annotationClass.getName()).collect(Collectors.joining(", @")), argument.getType().getName())));
                        }
                    });
                }

                private void validateFields(NamedObject model, Optional<Class> implementingType, Class implementingClass, Class<? extends Annotation> ... annotationClasses) {
                    implementingType.ifPresent(type -> this.validateType(model, (Class<?>)type, implementingClass, annotationClasses));
                }

                private void validateType(NamedObject model, Class<?> type, Class implementingClass, Class<? extends Annotation> ... annotationClasses) {
                    Field field;
                    List<Field> fields = IntrospectionUtils.getAnnotatedFields(type, annotationClasses);
                    if (fields.isEmpty()) {
                        return;
                    }
                    if (fields.size() > 1) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' has %d fields annotated with one of [@%s]. Only one field may carry that annotation", type.getName(), fields.size(), Stream.of(annotationClasses).map(annotationClass -> annotationClass.getName()).collect(Collectors.joining(", @")))));
                    }
                    if (!implementingClass.equals((field = fields.get(0)).getType())) {
                        this.val$problemsReporter.addError(new Problem(model, String.format("Class '%s' declares the field '%s' which is annotated with one of [@%s] and is of type '%s'. Only fields of type String are allowed to carry such annotation", type.getName(), field.getName(), Stream.of(annotationClasses).map(annotationClass -> annotationClass.getName()).collect(Collectors.joining(", @")), field.getType().getName())));
                    }
                }
            }.walk(extensionModel));
        }
    }
}

