/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import javax.xml.namespace.QName;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.property.SyntheticModelModelProperty;
import org.mule.runtime.internal.dsl.DslConstants;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureTypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.sdk.api.runtime.source.PollingSource;

public class PollingSourceDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private static final String POLLING_SOURCE_LIMIT_MULE_VERSION = "4.4.0";

    public void enrich(final ExtensionLoadingContext extensionLoadingContext) {
        final int schedulingStrategyParameterSequence = InfrastructureTypeResolver.getInfrastructureType(new TypeWrapper(SchedulingStrategy.class, new DefaultExtensionsTypeLoaderFactory().createTypeLoader(extensionLoadingContext.getExtensionClassLoader()))).map(infrastructureType -> infrastructureType.getSequence()).orElse(0);
        final ClassTypeLoader loader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
        final Reference thereArePollingSources = new Reference((Object)false);
        new IdempotentDeclarationWalker(){

            protected void onSource(SourceDeclaration source) {
                PollingSourceDeclarationEnricher.this.extractType((BaseDeclaration<? extends BaseDeclaration>)source).ifPresent(type -> {
                    if (type.isAssignableTo(org.mule.runtime.extension.api.runtime.source.PollingSource.class) || type.isAssignableTo(PollingSource.class)) {
                        thereArePollingSources.set((Object)true);
                        source.getParameterGroup("General").addParameter(this.declareSchedulingStrategyParameter(loader));
                        if (MuleExtensionUtils.isPollingSourceLimitEnabled(extensionLoadingContext)) {
                            source.getParameterGroup("General").addParameter(this.declarePollingSourceLimitParameter());
                        }
                    }
                });
            }

            private ParameterDeclaration declarePollingSourceLimitParameter() {
                ParameterDeclaration parameter = new ParameterDeclaration("maxItemsPerPoll");
                parameter.setDescription("Limits the amount of items per poll. ");
                parameter.setRequired(false);
                parameter.setType((MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).numberType().integer().range((Number)1, null).build(), false);
                parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                parameter.addModelProperty((ModelProperty)new SyntheticModelModelProperty());
                parameter.addModelProperty((ModelProperty)new SinceMuleVersionModelProperty(PollingSourceDeclarationEnricher.POLLING_SOURCE_LIMIT_MULE_VERSION));
                parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                return parameter;
            }

            private ParameterDeclaration declareSchedulingStrategyParameter(ClassTypeLoader loader2) {
                ParameterDeclaration parameter = new ParameterDeclaration("schedulingStrategy");
                parameter.setDescription("Configures the scheduler that triggers the polling");
                parameter.setRequired(true);
                parameter.setType(PollingSourceDeclarationEnricher.this.loadSchedulingStrategyType(loader2), false);
                parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                parameter.addModelProperty((ModelProperty)new InfrastructureParameterModelProperty(schedulingStrategyParameterSequence));
                parameter.addModelProperty((ModelProperty)new QNameModelProperty(new QName(DslConstants.CORE_NAMESPACE, "scheduling-strategy", "mule")));
                parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
                return parameter;
            }
        }.walk((ExtensionDeclaration)extensionDeclarer.getDeclaration());
        if (((Boolean)thereArePollingSources.get()).booleanValue() && !this.isSchedulerAlreadyImported((ExtensionDeclaration)extensionDeclarer.getDeclaration())) {
            ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
            extensionDeclarer.withImportedType(new ImportedTypeModel((ObjectType)this.loadSchedulingStrategyType(typeLoader)));
        }
    }

    private MetadataType loadSchedulingStrategyType(ClassTypeLoader loader) {
        return loader.load(SchedulingStrategy.class);
    }

    private boolean isSchedulerAlreadyImported(ExtensionDeclaration extension) {
        return extension.getImportedTypes().stream().anyMatch(model -> this.isScheduler((MetadataType)model.getImportedType()));
    }

    private boolean isScheduler(MetadataType type) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).filter(typeId -> SchedulingStrategy.class.getName().equals(typeId)).isPresent();
    }

    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }
}

